/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ChildReference;
import com.oracle.bmc.dataintegration.model.ReferenceUsedBy;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Reference {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="identifierPath")
    private final String identifierPath;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="targetObject")
    private final Object targetObject;
    @JsonProperty(value="applicationKey")
    private final String applicationKey;
    @JsonProperty(value="usedBy")
    private final List<ReferenceUsedBy> usedBy;
    @JsonProperty(value="childReferences")
    private final List<ChildReference> childReferences;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().key(this.key).name(this.name).identifier(this.identifier).identifierPath(this.identifierPath).description(this.description).type(this.type).targetObject(this.targetObject).applicationKey(this.applicationKey).usedBy(this.usedBy).childReferences(this.childReferences);
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getIdentifierPath() {
        return this.identifierPath;
    }

    public String getDescription() {
        return this.description;
    }

    public Type getType() {
        return this.type;
    }

    public Object getTargetObject() {
        return this.targetObject;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public List<ReferenceUsedBy> getUsedBy() {
        return this.usedBy;
    }

    public List<ChildReference> getChildReferences() {
        return this.childReferences;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Reference)) {
            return false;
        }
        Reference other = (Reference)o;
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        String this$identifierPath = this.getIdentifierPath();
        String other$identifierPath = other.getIdentifierPath();
        if (this$identifierPath == null ? other$identifierPath != null : !this$identifierPath.equals(other$identifierPath)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Object this$targetObject = this.getTargetObject();
        Object other$targetObject = other.getTargetObject();
        if (this$targetObject == null ? other$targetObject != null : !this$targetObject.equals(other$targetObject)) {
            return false;
        }
        String this$applicationKey = this.getApplicationKey();
        String other$applicationKey = other.getApplicationKey();
        if (this$applicationKey == null ? other$applicationKey != null : !this$applicationKey.equals(other$applicationKey)) {
            return false;
        }
        List<ReferenceUsedBy> this$usedBy = this.getUsedBy();
        List<ReferenceUsedBy> other$usedBy = other.getUsedBy();
        if (this$usedBy == null ? other$usedBy != null : !((Object)this$usedBy).equals(other$usedBy)) {
            return false;
        }
        List<ChildReference> this$childReferences = this.getChildReferences();
        List<ChildReference> other$childReferences = other.getChildReferences();
        if (this$childReferences == null ? other$childReferences != null : !((Object)this$childReferences).equals(other$childReferences)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        String $identifierPath = this.getIdentifierPath();
        result = result * 59 + ($identifierPath == null ? 43 : $identifierPath.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Object $targetObject = this.getTargetObject();
        result = result * 59 + ($targetObject == null ? 43 : $targetObject.hashCode());
        String $applicationKey = this.getApplicationKey();
        result = result * 59 + ($applicationKey == null ? 43 : $applicationKey.hashCode());
        List<ReferenceUsedBy> $usedBy = this.getUsedBy();
        result = result * 59 + ($usedBy == null ? 43 : ((Object)$usedBy).hashCode());
        List<ChildReference> $childReferences = this.getChildReferences();
        result = result * 59 + ($childReferences == null ? 43 : ((Object)$childReferences).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "Reference(key=" + this.getKey() + ", name=" + this.getName() + ", identifier=" + this.getIdentifier() + ", identifierPath=" + this.getIdentifierPath() + ", description=" + this.getDescription() + ", type=" + (Object)((Object)this.getType()) + ", targetObject=" + this.getTargetObject() + ", applicationKey=" + this.getApplicationKey() + ", usedBy=" + this.getUsedBy() + ", childReferences=" + this.getChildReferences() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"key", "name", "identifier", "identifierPath", "description", "type", "targetObject", "applicationKey", "usedBy", "childReferences"})
    @Deprecated
    public Reference(String key, String name, String identifier, String identifierPath, String description, Type type, Object targetObject, String applicationKey, List<ReferenceUsedBy> usedBy, List<ChildReference> childReferences) {
        this.key = key;
        this.name = name;
        this.identifier = identifier;
        this.identifierPath = identifierPath;
        this.description = description;
        this.type = type;
        this.targetObject = targetObject;
        this.applicationKey = applicationKey;
        this.usedBy = usedBy;
        this.childReferences = childReferences;
    }

    public static enum Type {
        OracleDataAsset("ORACLE_DATA_ASSET"),
        OracleObjectStorageDataAsset("ORACLE_OBJECT_STORAGE_DATA_ASSET"),
        OracleAtpDataAsset("ORACLE_ATP_DATA_ASSET"),
        OracleAdwcDataAsset("ORACLE_ADWC_DATA_ASSET"),
        MysqlDataAsset("MYSQL_DATA_ASSET"),
        GenericJdbcDataAsset("GENERIC_JDBC_DATA_ASSET"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="identifierPath")
        private String identifierPath;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="targetObject")
        private Object targetObject;
        @JsonProperty(value="applicationKey")
        private String applicationKey;
        @JsonProperty(value="usedBy")
        private List<ReferenceUsedBy> usedBy;
        @JsonProperty(value="childReferences")
        private List<ChildReference> childReferences;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder identifierPath(String identifierPath) {
            this.identifierPath = identifierPath;
            this.__explicitlySet__.add("identifierPath");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder targetObject(Object targetObject) {
            this.targetObject = targetObject;
            this.__explicitlySet__.add("targetObject");
            return this;
        }

        public Builder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            this.__explicitlySet__.add("applicationKey");
            return this;
        }

        public Builder usedBy(List<ReferenceUsedBy> usedBy) {
            this.usedBy = usedBy;
            this.__explicitlySet__.add("usedBy");
            return this;
        }

        public Builder childReferences(List<ChildReference> childReferences) {
            this.childReferences = childReferences;
            this.__explicitlySet__.add("childReferences");
            return this;
        }

        public Reference build() {
            Reference __instance__ = new Reference(this.key, this.name, this.identifier, this.identifierPath, this.description, this.type, this.targetObject, this.applicationKey, this.usedBy, this.childReferences);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(Reference o) {
            Builder copiedBuilder = this.key(o.getKey()).name(o.getName()).identifier(o.getIdentifier()).identifierPath(o.getIdentifierPath()).description(o.getDescription()).type(o.getType()).targetObject(o.getTargetObject()).applicationKey(o.getApplicationKey()).usedBy(o.getUsedBy()).childReferences(o.getChildReferences());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "Reference.Builder(key=" + this.key + ", name=" + this.name + ", identifier=" + this.identifier + ", identifierPath=" + this.identifierPath + ", description=" + this.description + ", type=" + (Object)((Object)this.type) + ", targetObject=" + this.targetObject + ", applicationKey=" + this.applicationKey + ", usedBy=" + this.usedBy + ", childReferences=" + this.childReferences + ")";
        }
    }
}

