/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ObjectMetadata;
import com.oracle.bmc.dataintegration.model.ParentReference;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TaskRunSummary {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelType")
    private final String modelType;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="objectVersion")
    private final Integer objectVersion;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="startTimeMillis")
    private final Long startTimeMillis;
    @JsonProperty(value="endTimeMillis")
    private final Long endTimeMillis;
    @JsonProperty(value="lastUpdated")
    private final Long lastUpdated;
    @JsonProperty(value="recordsWritten")
    private final Long recordsWritten;
    @JsonProperty(value="bytesProcessed")
    private final Long bytesProcessed;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="taskType")
    private final TaskType taskType;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="metadata")
    private final ObjectMetadata metadata;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().key(this.key).modelType(this.modelType).modelVersion(this.modelVersion).parentRef(this.parentRef).name(this.name).description(this.description).objectVersion(this.objectVersion).status(this.status).startTimeMillis(this.startTimeMillis).endTimeMillis(this.endTimeMillis).lastUpdated(this.lastUpdated).recordsWritten(this.recordsWritten).bytesProcessed(this.bytesProcessed).objectStatus(this.objectStatus).taskType(this.taskType).identifier(this.identifier).metadata(this.metadata);
    }

    public String getKey() {
        return this.key;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public Status getStatus() {
        return this.status;
    }

    public Long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public Long getEndTimeMillis() {
        return this.endTimeMillis;
    }

    public Long getLastUpdated() {
        return this.lastUpdated;
    }

    public Long getRecordsWritten() {
        return this.recordsWritten;
    }

    public Long getBytesProcessed() {
        return this.bytesProcessed;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskRunSummary)) {
            return false;
        }
        TaskRunSummary other = (TaskRunSummary)o;
        Integer this$objectVersion = this.getObjectVersion();
        Integer other$objectVersion = other.getObjectVersion();
        if (this$objectVersion == null ? other$objectVersion != null : !((Object)this$objectVersion).equals(other$objectVersion)) {
            return false;
        }
        Long this$startTimeMillis = this.getStartTimeMillis();
        Long other$startTimeMillis = other.getStartTimeMillis();
        if (this$startTimeMillis == null ? other$startTimeMillis != null : !((Object)this$startTimeMillis).equals(other$startTimeMillis)) {
            return false;
        }
        Long this$endTimeMillis = this.getEndTimeMillis();
        Long other$endTimeMillis = other.getEndTimeMillis();
        if (this$endTimeMillis == null ? other$endTimeMillis != null : !((Object)this$endTimeMillis).equals(other$endTimeMillis)) {
            return false;
        }
        Long this$lastUpdated = this.getLastUpdated();
        Long other$lastUpdated = other.getLastUpdated();
        if (this$lastUpdated == null ? other$lastUpdated != null : !((Object)this$lastUpdated).equals(other$lastUpdated)) {
            return false;
        }
        Long this$recordsWritten = this.getRecordsWritten();
        Long other$recordsWritten = other.getRecordsWritten();
        if (this$recordsWritten == null ? other$recordsWritten != null : !((Object)this$recordsWritten).equals(other$recordsWritten)) {
            return false;
        }
        Long this$bytesProcessed = this.getBytesProcessed();
        Long other$bytesProcessed = other.getBytesProcessed();
        if (this$bytesProcessed == null ? other$bytesProcessed != null : !((Object)this$bytesProcessed).equals(other$bytesProcessed)) {
            return false;
        }
        Integer this$objectStatus = this.getObjectStatus();
        Integer other$objectStatus = other.getObjectStatus();
        if (this$objectStatus == null ? other$objectStatus != null : !((Object)this$objectStatus).equals(other$objectStatus)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$modelType = this.getModelType();
        String other$modelType = other.getModelType();
        if (this$modelType == null ? other$modelType != null : !this$modelType.equals(other$modelType)) {
            return false;
        }
        String this$modelVersion = this.getModelVersion();
        String other$modelVersion = other.getModelVersion();
        if (this$modelVersion == null ? other$modelVersion != null : !this$modelVersion.equals(other$modelVersion)) {
            return false;
        }
        ParentReference this$parentRef = this.getParentRef();
        ParentReference other$parentRef = other.getParentRef();
        if (this$parentRef == null ? other$parentRef != null : !((Object)this$parentRef).equals(other$parentRef)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        TaskType this$taskType = this.getTaskType();
        TaskType other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !((Object)((Object)this$taskType)).equals((Object)other$taskType)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        ObjectMetadata this$metadata = this.getMetadata();
        ObjectMetadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $objectVersion = this.getObjectVersion();
        result = result * 59 + ($objectVersion == null ? 43 : ((Object)$objectVersion).hashCode());
        Long $startTimeMillis = this.getStartTimeMillis();
        result = result * 59 + ($startTimeMillis == null ? 43 : ((Object)$startTimeMillis).hashCode());
        Long $endTimeMillis = this.getEndTimeMillis();
        result = result * 59 + ($endTimeMillis == null ? 43 : ((Object)$endTimeMillis).hashCode());
        Long $lastUpdated = this.getLastUpdated();
        result = result * 59 + ($lastUpdated == null ? 43 : ((Object)$lastUpdated).hashCode());
        Long $recordsWritten = this.getRecordsWritten();
        result = result * 59 + ($recordsWritten == null ? 43 : ((Object)$recordsWritten).hashCode());
        Long $bytesProcessed = this.getBytesProcessed();
        result = result * 59 + ($bytesProcessed == null ? 43 : ((Object)$bytesProcessed).hashCode());
        Integer $objectStatus = this.getObjectStatus();
        result = result * 59 + ($objectStatus == null ? 43 : ((Object)$objectStatus).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $modelType = this.getModelType();
        result = result * 59 + ($modelType == null ? 43 : $modelType.hashCode());
        String $modelVersion = this.getModelVersion();
        result = result * 59 + ($modelVersion == null ? 43 : $modelVersion.hashCode());
        ParentReference $parentRef = this.getParentRef();
        result = result * 59 + ($parentRef == null ? 43 : ((Object)$parentRef).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        TaskType $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : ((Object)((Object)$taskType)).hashCode());
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        ObjectMetadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "TaskRunSummary(key=" + this.getKey() + ", modelType=" + this.getModelType() + ", modelVersion=" + this.getModelVersion() + ", parentRef=" + this.getParentRef() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", objectVersion=" + this.getObjectVersion() + ", status=" + (Object)((Object)this.getStatus()) + ", startTimeMillis=" + this.getStartTimeMillis() + ", endTimeMillis=" + this.getEndTimeMillis() + ", lastUpdated=" + this.getLastUpdated() + ", recordsWritten=" + this.getRecordsWritten() + ", bytesProcessed=" + this.getBytesProcessed() + ", objectStatus=" + this.getObjectStatus() + ", taskType=" + (Object)((Object)this.getTaskType()) + ", identifier=" + this.getIdentifier() + ", metadata=" + this.getMetadata() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"key", "modelType", "modelVersion", "parentRef", "name", "description", "objectVersion", "status", "startTimeMillis", "endTimeMillis", "lastUpdated", "recordsWritten", "bytesProcessed", "objectStatus", "taskType", "identifier", "metadata"})
    @Deprecated
    public TaskRunSummary(String key, String modelType, String modelVersion, ParentReference parentRef, String name, String description, Integer objectVersion, Status status, Long startTimeMillis, Long endTimeMillis, Long lastUpdated, Long recordsWritten, Long bytesProcessed, Integer objectStatus, TaskType taskType, String identifier, ObjectMetadata metadata) {
        this.key = key;
        this.modelType = modelType;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.name = name;
        this.description = description;
        this.objectVersion = objectVersion;
        this.status = status;
        this.startTimeMillis = startTimeMillis;
        this.endTimeMillis = endTimeMillis;
        this.lastUpdated = lastUpdated;
        this.recordsWritten = recordsWritten;
        this.bytesProcessed = bytesProcessed;
        this.objectStatus = objectStatus;
        this.taskType = taskType;
        this.identifier = identifier;
        this.metadata = metadata;
    }

    public static enum TaskType {
        IntegrationTask("INTEGRATION_TASK"),
        DataLoaderTask("DATA_LOADER_TASK"),
        PipelineTask("PIPELINE_TASK"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TaskType> map;

        private TaskType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TaskType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TaskType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TaskType.class);
            map = new HashMap<String, TaskType>();
            for (TaskType v : TaskType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status {
        NotStarted("NOT_STARTED"),
        Queued("QUEUED"),
        Running("RUNNING"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Success("SUCCESS"),
        Error("ERROR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelType")
        private String modelType;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="startTimeMillis")
        private Long startTimeMillis;
        @JsonProperty(value="endTimeMillis")
        private Long endTimeMillis;
        @JsonProperty(value="lastUpdated")
        private Long lastUpdated;
        @JsonProperty(value="recordsWritten")
        private Long recordsWritten;
        @JsonProperty(value="bytesProcessed")
        private Long bytesProcessed;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="taskType")
        private TaskType taskType;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="metadata")
        private ObjectMetadata metadata;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelType(String modelType) {
            this.modelType = modelType;
            this.__explicitlySet__.add("modelType");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder startTimeMillis(Long startTimeMillis) {
            this.startTimeMillis = startTimeMillis;
            this.__explicitlySet__.add("startTimeMillis");
            return this;
        }

        public Builder endTimeMillis(Long endTimeMillis) {
            this.endTimeMillis = endTimeMillis;
            this.__explicitlySet__.add("endTimeMillis");
            return this;
        }

        public Builder lastUpdated(Long lastUpdated) {
            this.lastUpdated = lastUpdated;
            this.__explicitlySet__.add("lastUpdated");
            return this;
        }

        public Builder recordsWritten(Long recordsWritten) {
            this.recordsWritten = recordsWritten;
            this.__explicitlySet__.add("recordsWritten");
            return this;
        }

        public Builder bytesProcessed(Long bytesProcessed) {
            this.bytesProcessed = bytesProcessed;
            this.__explicitlySet__.add("bytesProcessed");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder taskType(TaskType taskType) {
            this.taskType = taskType;
            this.__explicitlySet__.add("taskType");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder metadata(ObjectMetadata metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public TaskRunSummary build() {
            TaskRunSummary __instance__ = new TaskRunSummary(this.key, this.modelType, this.modelVersion, this.parentRef, this.name, this.description, this.objectVersion, this.status, this.startTimeMillis, this.endTimeMillis, this.lastUpdated, this.recordsWritten, this.bytesProcessed, this.objectStatus, this.taskType, this.identifier, this.metadata);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(TaskRunSummary o) {
            Builder copiedBuilder = this.key(o.getKey()).modelType(o.getModelType()).modelVersion(o.getModelVersion()).parentRef(o.getParentRef()).name(o.getName()).description(o.getDescription()).objectVersion(o.getObjectVersion()).status(o.getStatus()).startTimeMillis(o.getStartTimeMillis()).endTimeMillis(o.getEndTimeMillis()).lastUpdated(o.getLastUpdated()).recordsWritten(o.getRecordsWritten()).bytesProcessed(o.getBytesProcessed()).objectStatus(o.getObjectStatus()).taskType(o.getTaskType()).identifier(o.getIdentifier()).metadata(o.getMetadata());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "TaskRunSummary.Builder(key=" + this.key + ", modelType=" + this.modelType + ", modelVersion=" + this.modelVersion + ", parentRef=" + this.parentRef + ", name=" + this.name + ", description=" + this.description + ", objectVersion=" + this.objectVersion + ", status=" + (Object)((Object)this.status) + ", startTimeMillis=" + this.startTimeMillis + ", endTimeMillis=" + this.endTimeMillis + ", lastUpdated=" + this.lastUpdated + ", recordsWritten=" + this.recordsWritten + ", bytesProcessed=" + this.bytesProcessed + ", objectStatus=" + this.objectStatus + ", taskType=" + (Object)((Object)this.taskType) + ", identifier=" + this.identifier + ", metadata=" + this.metadata + ")";
        }
    }
}

