/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.CreateConnectionDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateConnectionRequest
extends BmcRequest<CreateConnectionDetails> {
    private String workspaceId;
    private CreateConnectionDetails createConnectionDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public CreateConnectionDetails getBody$() {
        return this.createConnectionDetails;
    }

    @ConstructorProperties(value={"workspaceId", "createConnectionDetails", "opcRequestId", "opcRetryToken"})
    CreateConnectionRequest(String workspaceId, CreateConnectionDetails createConnectionDetails, String opcRequestId, String opcRetryToken) {
        this.workspaceId = workspaceId;
        this.createConnectionDetails = createConnectionDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public CreateConnectionDetails getCreateConnectionDetails() {
        return this.createConnectionDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateConnectionRequest, CreateConnectionDetails> {
        private String workspaceId;
        private CreateConnectionDetails createConnectionDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateConnectionRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.createConnectionDetails(o.getCreateConnectionDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateConnectionRequest build() {
            CreateConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateConnectionDetails body) {
            this.createConnectionDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder createConnectionDetails(CreateConnectionDetails createConnectionDetails) {
            this.createConnectionDetails = createConnectionDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateConnectionRequest buildWithoutInvocationCallback() {
            return new CreateConnectionRequest(this.workspaceId, this.createConnectionDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "CreateConnectionRequest.Builder(workspaceId=" + this.workspaceId + ", createConnectionDetails=" + this.createConnectionDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

