/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.CreateConnectionValidationDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateConnectionValidationRequest
extends BmcRequest<CreateConnectionValidationDetails> {
    private String workspaceId;
    private CreateConnectionValidationDetails createConnectionValidationDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public CreateConnectionValidationDetails getBody$() {
        return this.createConnectionValidationDetails;
    }

    @ConstructorProperties(value={"workspaceId", "createConnectionValidationDetails", "opcRequestId", "opcRetryToken"})
    CreateConnectionValidationRequest(String workspaceId, CreateConnectionValidationDetails createConnectionValidationDetails, String opcRequestId, String opcRetryToken) {
        this.workspaceId = workspaceId;
        this.createConnectionValidationDetails = createConnectionValidationDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public CreateConnectionValidationDetails getCreateConnectionValidationDetails() {
        return this.createConnectionValidationDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateConnectionValidationRequest, CreateConnectionValidationDetails> {
        private String workspaceId;
        private CreateConnectionValidationDetails createConnectionValidationDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateConnectionValidationRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.createConnectionValidationDetails(o.getCreateConnectionValidationDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateConnectionValidationRequest build() {
            CreateConnectionValidationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateConnectionValidationDetails body) {
            this.createConnectionValidationDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder createConnectionValidationDetails(CreateConnectionValidationDetails createConnectionValidationDetails) {
            this.createConnectionValidationDetails = createConnectionValidationDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateConnectionValidationRequest buildWithoutInvocationCallback() {
            return new CreateConnectionValidationRequest(this.workspaceId, this.createConnectionValidationDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "CreateConnectionValidationRequest.Builder(workspaceId=" + this.workspaceId + ", createConnectionValidationDetails=" + this.createConnectionValidationDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

