/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.CreateDataAssetDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateDataAssetRequest
extends BmcRequest<CreateDataAssetDetails> {
    private String workspaceId;
    private CreateDataAssetDetails createDataAssetDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public CreateDataAssetDetails getBody$() {
        return this.createDataAssetDetails;
    }

    @ConstructorProperties(value={"workspaceId", "createDataAssetDetails", "opcRequestId", "opcRetryToken"})
    CreateDataAssetRequest(String workspaceId, CreateDataAssetDetails createDataAssetDetails, String opcRequestId, String opcRetryToken) {
        this.workspaceId = workspaceId;
        this.createDataAssetDetails = createDataAssetDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public CreateDataAssetDetails getCreateDataAssetDetails() {
        return this.createDataAssetDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateDataAssetRequest, CreateDataAssetDetails> {
        private String workspaceId;
        private CreateDataAssetDetails createDataAssetDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateDataAssetRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.createDataAssetDetails(o.getCreateDataAssetDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateDataAssetRequest build() {
            CreateDataAssetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateDataAssetDetails body) {
            this.createDataAssetDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder createDataAssetDetails(CreateDataAssetDetails createDataAssetDetails) {
            this.createDataAssetDetails = createDataAssetDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateDataAssetRequest buildWithoutInvocationCallback() {
            return new CreateDataAssetRequest(this.workspaceId, this.createDataAssetDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "CreateDataAssetRequest.Builder(workspaceId=" + this.workspaceId + ", createDataAssetDetails=" + this.createDataAssetDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

