/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.CreateProjectDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateProjectRequest
extends BmcRequest<CreateProjectDetails> {
    private String workspaceId;
    private CreateProjectDetails createProjectDetails;
    private String opcRetryToken;
    private String opcRequestId;

    @InternalSdk
    public CreateProjectDetails getBody$() {
        return this.createProjectDetails;
    }

    @ConstructorProperties(value={"workspaceId", "createProjectDetails", "opcRetryToken", "opcRequestId"})
    CreateProjectRequest(String workspaceId, CreateProjectDetails createProjectDetails, String opcRetryToken, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.createProjectDetails = createProjectDetails;
        this.opcRetryToken = opcRetryToken;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public CreateProjectDetails getCreateProjectDetails() {
        return this.createProjectDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateProjectRequest, CreateProjectDetails> {
        private String workspaceId;
        private CreateProjectDetails createProjectDetails;
        private String opcRetryToken;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateProjectRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.createProjectDetails(o.getCreateProjectDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateProjectRequest build() {
            CreateProjectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateProjectDetails body) {
            this.createProjectDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder createProjectDetails(CreateProjectDetails createProjectDetails) {
            this.createProjectDetails = createProjectDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public CreateProjectRequest buildWithoutInvocationCallback() {
            return new CreateProjectRequest(this.workspaceId, this.createProjectDetails, this.opcRetryToken, this.opcRequestId);
        }

        public String toString() {
            return "CreateProjectRequest.Builder(workspaceId=" + this.workspaceId + ", createProjectDetails=" + this.createProjectDetails + ", opcRetryToken=" + this.opcRetryToken + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

