/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteConnectionRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String connectionKey;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"workspaceId", "connectionKey", "ifMatch", "opcRequestId"})
    DeleteConnectionRequest(String workspaceId, String connectionKey, String ifMatch, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.connectionKey = connectionKey;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getConnectionKey() {
        return this.connectionKey;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteConnectionRequest, Void> {
        private String workspaceId;
        private String connectionKey;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteConnectionRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.connectionKey(o.getConnectionKey());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteConnectionRequest build() {
            DeleteConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder connectionKey(String connectionKey) {
            this.connectionKey = connectionKey;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteConnectionRequest buildWithoutInvocationCallback() {
            return new DeleteConnectionRequest(this.workspaceId, this.connectionKey, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "DeleteConnectionRequest.Builder(workspaceId=" + this.workspaceId + ", connectionKey=" + this.connectionKey + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

