/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteDataFlowRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String dataFlowKey;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"workspaceId", "dataFlowKey", "ifMatch", "opcRequestId"})
    DeleteDataFlowRequest(String workspaceId, String dataFlowKey, String ifMatch, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.dataFlowKey = dataFlowKey;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getDataFlowKey() {
        return this.dataFlowKey;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteDataFlowRequest, Void> {
        private String workspaceId;
        private String dataFlowKey;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteDataFlowRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.dataFlowKey(o.getDataFlowKey());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteDataFlowRequest build() {
            DeleteDataFlowRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder dataFlowKey(String dataFlowKey) {
            this.dataFlowKey = dataFlowKey;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteDataFlowRequest buildWithoutInvocationCallback() {
            return new DeleteDataFlowRequest(this.workspaceId, this.dataFlowKey, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "DeleteDataFlowRequest.Builder(workspaceId=" + this.workspaceId + ", dataFlowKey=" + this.dataFlowKey + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

