/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteExternalPublicationRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String taskKey;
    private String externalPublicationsKey;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"workspaceId", "taskKey", "externalPublicationsKey", "ifMatch", "opcRequestId"})
    DeleteExternalPublicationRequest(String workspaceId, String taskKey, String externalPublicationsKey, String ifMatch, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.taskKey = taskKey;
        this.externalPublicationsKey = externalPublicationsKey;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getTaskKey() {
        return this.taskKey;
    }

    public String getExternalPublicationsKey() {
        return this.externalPublicationsKey;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteExternalPublicationRequest, Void> {
        private String workspaceId;
        private String taskKey;
        private String externalPublicationsKey;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteExternalPublicationRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.taskKey(o.getTaskKey());
            this.externalPublicationsKey(o.getExternalPublicationsKey());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteExternalPublicationRequest build() {
            DeleteExternalPublicationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder taskKey(String taskKey) {
            this.taskKey = taskKey;
            return this;
        }

        public Builder externalPublicationsKey(String externalPublicationsKey) {
            this.externalPublicationsKey = externalPublicationsKey;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteExternalPublicationRequest buildWithoutInvocationCallback() {
            return new DeleteExternalPublicationRequest(this.workspaceId, this.taskKey, this.externalPublicationsKey, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "DeleteExternalPublicationRequest.Builder(workspaceId=" + this.workspaceId + ", taskKey=" + this.taskKey + ", externalPublicationsKey=" + this.externalPublicationsKey + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

