/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteTaskRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String taskKey;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"workspaceId", "taskKey", "ifMatch", "opcRequestId"})
    DeleteTaskRequest(String workspaceId, String taskKey, String ifMatch, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.taskKey = taskKey;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getTaskKey() {
        return this.taskKey;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteTaskRequest, Void> {
        private String workspaceId;
        private String taskKey;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteTaskRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.taskKey(o.getTaskKey());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteTaskRequest build() {
            DeleteTaskRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder taskKey(String taskKey) {
            this.taskKey = taskKey;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteTaskRequest buildWithoutInvocationCallback() {
            return new DeleteTaskRequest(this.workspaceId, this.taskKey, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "DeleteTaskRequest.Builder(workspaceId=" + this.workspaceId + ", taskKey=" + this.taskKey + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

