/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetDependentObjectRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String applicationKey;
    private String dependentObjectKey;
    private String opcRequestId;

    @ConstructorProperties(value={"workspaceId", "applicationKey", "dependentObjectKey", "opcRequestId"})
    GetDependentObjectRequest(String workspaceId, String applicationKey, String dependentObjectKey, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.applicationKey = applicationKey;
        this.dependentObjectKey = dependentObjectKey;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public String getDependentObjectKey() {
        return this.dependentObjectKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDependentObjectRequest, Void> {
        private String workspaceId;
        private String applicationKey;
        private String dependentObjectKey;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDependentObjectRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.applicationKey(o.getApplicationKey());
            this.dependentObjectKey(o.getDependentObjectKey());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDependentObjectRequest build() {
            GetDependentObjectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            return this;
        }

        public Builder dependentObjectKey(String dependentObjectKey) {
            this.dependentObjectKey = dependentObjectKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetDependentObjectRequest buildWithoutInvocationCallback() {
            return new GetDependentObjectRequest(this.workspaceId, this.applicationKey, this.dependentObjectKey, this.opcRequestId);
        }

        public String toString() {
            return "GetDependentObjectRequest.Builder(workspaceId=" + this.workspaceId + ", applicationKey=" + this.applicationKey + ", dependentObjectKey=" + this.dependentObjectKey + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

