/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetPatchRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String applicationKey;
    private String patchKey;
    private String opcRequestId;

    @ConstructorProperties(value={"workspaceId", "applicationKey", "patchKey", "opcRequestId"})
    GetPatchRequest(String workspaceId, String applicationKey, String patchKey, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.applicationKey = applicationKey;
        this.patchKey = patchKey;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public String getPatchKey() {
        return this.patchKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPatchRequest, Void> {
        private String workspaceId;
        private String applicationKey;
        private String patchKey;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPatchRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.applicationKey(o.getApplicationKey());
            this.patchKey(o.getPatchKey());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPatchRequest build() {
            GetPatchRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            return this;
        }

        public Builder patchKey(String patchKey) {
            this.patchKey = patchKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetPatchRequest buildWithoutInvocationCallback() {
            return new GetPatchRequest(this.workspaceId, this.applicationKey, this.patchKey, this.opcRequestId);
        }

        public String toString() {
            return "GetPatchRequest.Builder(workspaceId=" + this.workspaceId + ", applicationKey=" + this.applicationKey + ", patchKey=" + this.patchKey + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

