/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetPipelineRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String pipelineKey;
    private String opcRequestId;

    @ConstructorProperties(value={"workspaceId", "pipelineKey", "opcRequestId"})
    GetPipelineRequest(String workspaceId, String pipelineKey, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.pipelineKey = pipelineKey;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getPipelineKey() {
        return this.pipelineKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPipelineRequest, Void> {
        private String workspaceId;
        private String pipelineKey;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPipelineRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.pipelineKey(o.getPipelineKey());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPipelineRequest build() {
            GetPipelineRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder pipelineKey(String pipelineKey) {
            this.pipelineKey = pipelineKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetPipelineRequest buildWithoutInvocationCallback() {
            return new GetPipelineRequest(this.workspaceId, this.pipelineKey, this.opcRequestId);
        }

        public String toString() {
            return "GetPipelineRequest.Builder(workspaceId=" + this.workspaceId + ", pipelineKey=" + this.pipelineKey + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

