/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetProjectRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String projectKey;
    private String opcRequestId;

    @ConstructorProperties(value={"workspaceId", "projectKey", "opcRequestId"})
    GetProjectRequest(String workspaceId, String projectKey, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.projectKey = projectKey;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetProjectRequest, Void> {
        private String workspaceId;
        private String projectKey;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetProjectRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.projectKey(o.getProjectKey());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetProjectRequest build() {
            GetProjectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder projectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetProjectRequest buildWithoutInvocationCallback() {
            return new GetProjectRequest(this.workspaceId, this.projectKey, this.opcRequestId);
        }

        public String toString() {
            return "GetProjectRequest.Builder(workspaceId=" + this.workspaceId + ", projectKey=" + this.projectKey + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

