/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetReferenceRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String applicationKey;
    private String referenceKey;
    private String opcRequestId;

    @ConstructorProperties(value={"workspaceId", "applicationKey", "referenceKey", "opcRequestId"})
    GetReferenceRequest(String workspaceId, String applicationKey, String referenceKey, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.applicationKey = applicationKey;
        this.referenceKey = referenceKey;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public String getReferenceKey() {
        return this.referenceKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetReferenceRequest, Void> {
        private String workspaceId;
        private String applicationKey;
        private String referenceKey;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetReferenceRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.applicationKey(o.getApplicationKey());
            this.referenceKey(o.getReferenceKey());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetReferenceRequest build() {
            GetReferenceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            return this;
        }

        public Builder referenceKey(String referenceKey) {
            this.referenceKey = referenceKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetReferenceRequest buildWithoutInvocationCallback() {
            return new GetReferenceRequest(this.workspaceId, this.applicationKey, this.referenceKey, this.opcRequestId);
        }

        public String toString() {
            return "GetReferenceRequest.Builder(workspaceId=" + this.workspaceId + ", applicationKey=" + this.applicationKey + ", referenceKey=" + this.referenceKey + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

