/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetTaskRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String taskKey;
    private String opcRequestId;
    private String expandReferences;

    @ConstructorProperties(value={"workspaceId", "taskKey", "opcRequestId", "expandReferences"})
    GetTaskRequest(String workspaceId, String taskKey, String opcRequestId, String expandReferences) {
        this.workspaceId = workspaceId;
        this.taskKey = taskKey;
        this.opcRequestId = opcRequestId;
        this.expandReferences = expandReferences;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getTaskKey() {
        return this.taskKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getExpandReferences() {
        return this.expandReferences;
    }

    public static class Builder
    implements BmcRequest.Builder<GetTaskRequest, Void> {
        private String workspaceId;
        private String taskKey;
        private String opcRequestId;
        private String expandReferences;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetTaskRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.taskKey(o.getTaskKey());
            this.opcRequestId(o.getOpcRequestId());
            this.expandReferences(o.getExpandReferences());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetTaskRequest build() {
            GetTaskRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder taskKey(String taskKey) {
            this.taskKey = taskKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder expandReferences(String expandReferences) {
            this.expandReferences = expandReferences;
            return this;
        }

        public GetTaskRequest buildWithoutInvocationCallback() {
            return new GetTaskRequest(this.workspaceId, this.taskKey, this.opcRequestId, this.expandReferences);
        }

        public String toString() {
            return "GetTaskRequest.Builder(workspaceId=" + this.workspaceId + ", taskKey=" + this.taskKey + ", opcRequestId=" + this.opcRequestId + ", expandReferences=" + this.expandReferences + ")";
        }
    }
}

