/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetTaskRunRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String applicationKey;
    private String taskRunKey;
    private String opcRequestId;

    @ConstructorProperties(value={"workspaceId", "applicationKey", "taskRunKey", "opcRequestId"})
    GetTaskRunRequest(String workspaceId, String applicationKey, String taskRunKey, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.applicationKey = applicationKey;
        this.taskRunKey = taskRunKey;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public String getTaskRunKey() {
        return this.taskRunKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetTaskRunRequest, Void> {
        private String workspaceId;
        private String applicationKey;
        private String taskRunKey;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetTaskRunRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.applicationKey(o.getApplicationKey());
            this.taskRunKey(o.getTaskRunKey());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetTaskRunRequest build() {
            GetTaskRunRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            return this;
        }

        public Builder taskRunKey(String taskRunKey) {
            this.taskRunKey = taskRunKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetTaskRunRequest buildWithoutInvocationCallback() {
            return new GetTaskRunRequest(this.workspaceId, this.applicationKey, this.taskRunKey, this.opcRequestId);
        }

        public String toString() {
            return "GetTaskRunRequest.Builder(workspaceId=" + this.workspaceId + ", applicationKey=" + this.applicationKey + ", taskRunKey=" + this.taskRunKey + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

