/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetTaskValidationRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String taskValidationKey;
    private String opcRequestId;

    @ConstructorProperties(value={"workspaceId", "taskValidationKey", "opcRequestId"})
    GetTaskValidationRequest(String workspaceId, String taskValidationKey, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.taskValidationKey = taskValidationKey;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getTaskValidationKey() {
        return this.taskValidationKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetTaskValidationRequest, Void> {
        private String workspaceId;
        private String taskValidationKey;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetTaskValidationRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.taskValidationKey(o.getTaskValidationKey());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetTaskValidationRequest build() {
            GetTaskValidationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder taskValidationKey(String taskValidationKey) {
            this.taskValidationKey = taskValidationKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetTaskValidationRequest buildWithoutInvocationCallback() {
            return new GetTaskValidationRequest(this.workspaceId, this.taskValidationKey, this.opcRequestId);
        }

        public String toString() {
            return "GetTaskValidationRequest.Builder(workspaceId=" + this.workspaceId + ", taskValidationKey=" + this.taskValidationKey + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

