/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListDependentObjectsRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String applicationKey;
    private List<String> fields;
    private String name;
    private List<String> identifier;
    private List<String> type;
    private String typeInSubtree;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    @ConstructorProperties(value={"workspaceId", "applicationKey", "fields", "name", "identifier", "type", "typeInSubtree", "limit", "page", "sortOrder", "sortBy", "opcRequestId"})
    ListDependentObjectsRequest(String workspaceId, String applicationKey, List<String> fields, String name, List<String> identifier, List<String> type, String typeInSubtree, Integer limit, String page, SortOrder sortOrder, SortBy sortBy, String opcRequestId) {
        this.workspaceId = workspaceId;
        this.applicationKey = applicationKey;
        this.fields = fields;
        this.name = name;
        this.identifier = identifier;
        this.type = type;
        this.typeInSubtree = typeInSubtree;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getIdentifier() {
        return this.identifier;
    }

    public List<String> getType() {
        return this.type;
    }

    public String getTypeInSubtree() {
        return this.typeInSubtree;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDependentObjectsRequest, Void> {
        private String workspaceId;
        private String applicationKey;
        private List<String> fields;
        private String name;
        private List<String> identifier;
        private List<String> type;
        private String typeInSubtree;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDependentObjectsRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.applicationKey(o.getApplicationKey());
            this.fields(o.getFields());
            this.name(o.getName());
            this.identifier(o.getIdentifier());
            this.type(o.getType());
            this.typeInSubtree(o.getTypeInSubtree());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDependentObjectsRequest build() {
            ListDependentObjectsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder identifier(List<String> identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder type(List<String> type) {
            this.type = type;
            return this;
        }

        public Builder typeInSubtree(String typeInSubtree) {
            this.typeInSubtree = typeInSubtree;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListDependentObjectsRequest buildWithoutInvocationCallback() {
            return new ListDependentObjectsRequest(this.workspaceId, this.applicationKey, this.fields, this.name, this.identifier, this.type, this.typeInSubtree, this.limit, this.page, this.sortOrder, this.sortBy, this.opcRequestId);
        }

        public String toString() {
            return "ListDependentObjectsRequest.Builder(workspaceId=" + this.workspaceId + ", applicationKey=" + this.applicationKey + ", fields=" + this.fields + ", name=" + this.name + ", identifier=" + this.identifier + ", type=" + this.type + ", typeInSubtree=" + this.typeInSubtree + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortBy {
        TimeCreated("TIME_CREATED"),
        DisplayName("DISPLAY_NAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

