/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.UpdateConnectionDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateConnectionRequest
extends BmcRequest<UpdateConnectionDetails> {
    private String workspaceId;
    private String connectionKey;
    private UpdateConnectionDetails updateConnectionDetails;
    private String opcRequestId;
    private String ifMatch;

    @InternalSdk
    public UpdateConnectionDetails getBody$() {
        return this.updateConnectionDetails;
    }

    @ConstructorProperties(value={"workspaceId", "connectionKey", "updateConnectionDetails", "opcRequestId", "ifMatch"})
    UpdateConnectionRequest(String workspaceId, String connectionKey, UpdateConnectionDetails updateConnectionDetails, String opcRequestId, String ifMatch) {
        this.workspaceId = workspaceId;
        this.connectionKey = connectionKey;
        this.updateConnectionDetails = updateConnectionDetails;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getConnectionKey() {
        return this.connectionKey;
    }

    public UpdateConnectionDetails getUpdateConnectionDetails() {
        return this.updateConnectionDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateConnectionRequest, UpdateConnectionDetails> {
        private String workspaceId;
        private String connectionKey;
        private UpdateConnectionDetails updateConnectionDetails;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateConnectionRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.connectionKey(o.getConnectionKey());
            this.updateConnectionDetails(o.getUpdateConnectionDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateConnectionRequest build() {
            UpdateConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateConnectionDetails body) {
            this.updateConnectionDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder connectionKey(String connectionKey) {
            this.connectionKey = connectionKey;
            return this;
        }

        public Builder updateConnectionDetails(UpdateConnectionDetails updateConnectionDetails) {
            this.updateConnectionDetails = updateConnectionDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateConnectionRequest buildWithoutInvocationCallback() {
            return new UpdateConnectionRequest(this.workspaceId, this.connectionKey, this.updateConnectionDetails, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "UpdateConnectionRequest.Builder(workspaceId=" + this.workspaceId + ", connectionKey=" + this.connectionKey + ", updateConnectionDetails=" + this.updateConnectionDetails + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

