/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.UpdateProjectDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateProjectRequest
extends BmcRequest<UpdateProjectDetails> {
    private String workspaceId;
    private String projectKey;
    private UpdateProjectDetails updateProjectDetails;
    private String opcRequestId;
    private String ifMatch;

    @InternalSdk
    public UpdateProjectDetails getBody$() {
        return this.updateProjectDetails;
    }

    @ConstructorProperties(value={"workspaceId", "projectKey", "updateProjectDetails", "opcRequestId", "ifMatch"})
    UpdateProjectRequest(String workspaceId, String projectKey, UpdateProjectDetails updateProjectDetails, String opcRequestId, String ifMatch) {
        this.workspaceId = workspaceId;
        this.projectKey = projectKey;
        this.updateProjectDetails = updateProjectDetails;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public UpdateProjectDetails getUpdateProjectDetails() {
        return this.updateProjectDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateProjectRequest, UpdateProjectDetails> {
        private String workspaceId;
        private String projectKey;
        private UpdateProjectDetails updateProjectDetails;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateProjectRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.projectKey(o.getProjectKey());
            this.updateProjectDetails(o.getUpdateProjectDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateProjectRequest build() {
            UpdateProjectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateProjectDetails body) {
            this.updateProjectDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder projectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        public Builder updateProjectDetails(UpdateProjectDetails updateProjectDetails) {
            this.updateProjectDetails = updateProjectDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateProjectRequest buildWithoutInvocationCallback() {
            return new UpdateProjectRequest(this.workspaceId, this.projectKey, this.updateProjectDetails, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "UpdateProjectRequest.Builder(workspaceId=" + this.workspaceId + ", projectKey=" + this.projectKey + ", updateProjectDetails=" + this.updateProjectDetails + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

