/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.Connection;
import com.oracle.bmc.dataintegration.model.DataAsset;
import com.oracle.bmc.dataintegration.model.Schema;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ConfigurationDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="dataAsset")
    private final DataAsset dataAsset;
    @JsonProperty(value="connection")
    private final Connection connection;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="schema")
    private final Schema schema;

    @Deprecated
    @ConstructorProperties(value={"dataAsset", "connection", "compartmentId", "schema"})
    public ConfigurationDetails(DataAsset dataAsset, Connection connection, String compartmentId, Schema schema) {
        this.dataAsset = dataAsset;
        this.connection = connection;
        this.compartmentId = compartmentId;
        this.schema = schema;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public DataAsset getDataAsset() {
        return this.dataAsset;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ConfigurationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("dataAsset=").append(String.valueOf((Object)this.dataAsset));
        sb.append(", connection=").append(String.valueOf((Object)this.connection));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", schema=").append(String.valueOf((Object)this.schema));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigurationDetails)) {
            return false;
        }
        ConfigurationDetails other = (ConfigurationDetails)((Object)o);
        return Objects.equals((Object)this.dataAsset, (Object)other.dataAsset) && Objects.equals((Object)this.connection, (Object)other.connection) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.schema, (Object)other.schema) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.dataAsset == null ? 43 : this.dataAsset.hashCode());
        result = result * 59 + (this.connection == null ? 43 : this.connection.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.schema == null ? 43 : this.schema.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="dataAsset")
        private DataAsset dataAsset;
        @JsonProperty(value="connection")
        private Connection connection;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="schema")
        private Schema schema;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder dataAsset(DataAsset dataAsset) {
            this.dataAsset = dataAsset;
            this.__explicitlySet__.add("dataAsset");
            return this;
        }

        public Builder connection(Connection connection) {
            this.connection = connection;
            this.__explicitlySet__.add("connection");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder schema(Schema schema) {
            this.schema = schema;
            this.__explicitlySet__.add("schema");
            return this;
        }

        public ConfigurationDetails build() {
            ConfigurationDetails model = new ConfigurationDetails(this.dataAsset, this.connection, this.compartmentId, this.schema);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ConfigurationDetails model) {
            if (model.wasPropertyExplicitlySet("dataAsset")) {
                this.dataAsset(model.getDataAsset());
            }
            if (model.wasPropertyExplicitlySet("connection")) {
                this.connection(model.getConnection());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("schema")) {
                this.schema(model.getSchema());
            }
            return this;
        }
    }
}

