/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dataintegration.model.ConnectionFromAdwc;
import com.oracle.bmc.dataintegration.model.ConnectionFromAmazonS3;
import com.oracle.bmc.dataintegration.model.ConnectionFromAtp;
import com.oracle.bmc.dataintegration.model.ConnectionFromBICC;
import com.oracle.bmc.dataintegration.model.ConnectionFromBIP;
import com.oracle.bmc.dataintegration.model.ConnectionFromJdbc;
import com.oracle.bmc.dataintegration.model.ConnectionFromLake;
import com.oracle.bmc.dataintegration.model.ConnectionFromMySQL;
import com.oracle.bmc.dataintegration.model.ConnectionFromObjectStorage;
import com.oracle.bmc.dataintegration.model.ConnectionFromOracle;
import com.oracle.bmc.dataintegration.model.ConnectionFromRestBasicAuth;
import com.oracle.bmc.dataintegration.model.ConnectionFromRestNoAuth;
import com.oracle.bmc.dataintegration.model.ConnectionProperty;
import com.oracle.bmc.dataintegration.model.ObjectMetadata;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.Schema;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType", defaultImpl=Connection.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ConnectionFromObjectStorage.class, name="ORACLE_OBJECT_STORAGE_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromAdwc.class, name="ORACLE_ADWC_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromAtp.class, name="ORACLE_ATP_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromOracle.class, name="ORACLEDB_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromAmazonS3.class, name="AMAZON_S3_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromBIP.class, name="BIP_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromMySQL.class, name="MYSQL_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromJdbc.class, name="GENERIC_JDBC_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromBICC.class, name="BICC_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromRestNoAuth.class, name="REST_NO_AUTH_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromLake.class, name="LAKE_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromRestBasicAuth.class, name="REST_BASIC_AUTH_CONNECTION")})
@JsonFilter(value="explicitlySetFilter")
public class Connection
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="objectVersion")
    private final Integer objectVersion;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="primarySchema")
    private final Schema primarySchema;
    @JsonProperty(value="connectionProperties")
    private final List<ConnectionProperty> connectionProperties;
    @JsonProperty(value="isDefault")
    private final Boolean isDefault;
    @JsonProperty(value="metadata")
    private final ObjectMetadata metadata;
    @JsonProperty(value="keyMap")
    private final Map<String, String> keyMap;

    @Deprecated
    @ConstructorProperties(value={"key", "modelVersion", "parentRef", "name", "description", "objectVersion", "objectStatus", "identifier", "primarySchema", "connectionProperties", "isDefault", "metadata", "keyMap"})
    protected Connection(String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectVersion, Integer objectStatus, String identifier, Schema primarySchema, List<ConnectionProperty> connectionProperties, Boolean isDefault, ObjectMetadata metadata, Map<String, String> keyMap) {
        this.key = key;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.name = name;
        this.description = description;
        this.objectVersion = objectVersion;
        this.objectStatus = objectStatus;
        this.identifier = identifier;
        this.primarySchema = primarySchema;
        this.connectionProperties = connectionProperties;
        this.isDefault = isDefault;
        this.metadata = metadata;
        this.keyMap = keyMap;
    }

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Schema getPrimarySchema() {
        return this.primarySchema;
    }

    public List<ConnectionProperty> getConnectionProperties() {
        return this.connectionProperties;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public Map<String, String> getKeyMap() {
        return this.keyMap;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Connection(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", objectVersion=").append(String.valueOf(this.objectVersion));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(", identifier=").append(String.valueOf(this.identifier));
        sb.append(", primarySchema=").append(String.valueOf((Object)this.primarySchema));
        sb.append(", connectionProperties=").append(String.valueOf(this.connectionProperties));
        sb.append(", isDefault=").append(String.valueOf(this.isDefault));
        sb.append(", metadata=").append(String.valueOf((Object)this.metadata));
        sb.append(", keyMap=").append(String.valueOf(this.keyMap));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Connection)) {
            return false;
        }
        Connection other = (Connection)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.objectVersion, other.objectVersion) && Objects.equals(this.objectStatus, other.objectStatus) && Objects.equals(this.identifier, other.identifier) && Objects.equals((Object)this.primarySchema, (Object)other.primarySchema) && Objects.equals(this.connectionProperties, other.connectionProperties) && Objects.equals(this.isDefault, other.isDefault) && Objects.equals((Object)this.metadata, (Object)other.metadata) && Objects.equals(this.keyMap, other.keyMap) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.objectVersion == null ? 43 : this.objectVersion.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.primarySchema == null ? 43 : this.primarySchema.hashCode());
        result = result * 59 + (this.connectionProperties == null ? 43 : this.connectionProperties.hashCode());
        result = result * 59 + (this.isDefault == null ? 43 : this.isDefault.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + (this.keyMap == null ? 43 : this.keyMap.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ModelType implements BmcEnum
    {
        OracleAdwcConnection("ORACLE_ADWC_CONNECTION"),
        OracleAtpConnection("ORACLE_ATP_CONNECTION"),
        OracleObjectStorageConnection("ORACLE_OBJECT_STORAGE_CONNECTION"),
        OracledbConnection("ORACLEDB_CONNECTION"),
        MysqlConnection("MYSQL_CONNECTION"),
        GenericJdbcConnection("GENERIC_JDBC_CONNECTION"),
        BiccConnection("BICC_CONNECTION"),
        AmazonS3Connection("AMAZON_S3_CONNECTION"),
        BipConnection("BIP_CONNECTION"),
        LakeConnection("LAKE_CONNECTION"),
        RestNoAuthConnection("REST_NO_AUTH_CONNECTION"),
        RestBasicAuthConnection("REST_BASIC_AUTH_CONNECTION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ModelType> map;

        private ModelType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ModelType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ModelType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ModelType.class);
            map = new HashMap<String, ModelType>();
            for (ModelType v : ModelType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

