/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dataintegration.model.ConnectionFromAdwcDetails;
import com.oracle.bmc.dataintegration.model.ConnectionFromAmazonS3Details;
import com.oracle.bmc.dataintegration.model.ConnectionFromAtpDetails;
import com.oracle.bmc.dataintegration.model.ConnectionFromBICCDetails;
import com.oracle.bmc.dataintegration.model.ConnectionFromBipDetails;
import com.oracle.bmc.dataintegration.model.ConnectionFromJdbcDetails;
import com.oracle.bmc.dataintegration.model.ConnectionFromLakeDetails;
import com.oracle.bmc.dataintegration.model.ConnectionFromMySQLDetails;
import com.oracle.bmc.dataintegration.model.ConnectionFromObjectStorageDetails;
import com.oracle.bmc.dataintegration.model.ConnectionFromOracleDetails;
import com.oracle.bmc.dataintegration.model.ConnectionFromRestBasicAuthDetails;
import com.oracle.bmc.dataintegration.model.ConnectionFromRestNoAuthDetails;
import com.oracle.bmc.dataintegration.model.ConnectionProperty;
import com.oracle.bmc.dataintegration.model.ObjectMetadata;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.Schema;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType", defaultImpl=ConnectionDetails.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ConnectionFromJdbcDetails.class, name="GENERIC_JDBC_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromRestNoAuthDetails.class, name="REST_NO_AUTH_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromAmazonS3Details.class, name="AMAZON_S3_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromObjectStorageDetails.class, name="ORACLE_OBJECT_STORAGE_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromBICCDetails.class, name="BICC_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromMySQLDetails.class, name="MYSQL_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromAdwcDetails.class, name="ORACLE_ADWC_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromAtpDetails.class, name="ORACLE_ATP_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromOracleDetails.class, name="ORACLEDB_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromLakeDetails.class, name="LAKE_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromRestBasicAuthDetails.class, name="REST_BASIC_AUTH_CONNECTION"), @JsonSubTypes.Type(value=ConnectionFromBipDetails.class, name="BIP_CONNECTION")})
@JsonFilter(value="explicitlySetFilter")
public class ConnectionDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="objectVersion")
    private final Integer objectVersion;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="primarySchema")
    private final Schema primarySchema;
    @JsonProperty(value="connectionProperties")
    private final List<ConnectionProperty> connectionProperties;
    @JsonProperty(value="isDefault")
    private final Boolean isDefault;
    @JsonProperty(value="metadata")
    private final ObjectMetadata metadata;

    @Deprecated
    @ConstructorProperties(value={"key", "modelVersion", "parentRef", "name", "description", "objectVersion", "objectStatus", "identifier", "primarySchema", "connectionProperties", "isDefault", "metadata"})
    protected ConnectionDetails(String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectVersion, Integer objectStatus, String identifier, Schema primarySchema, List<ConnectionProperty> connectionProperties, Boolean isDefault, ObjectMetadata metadata) {
        this.key = key;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.name = name;
        this.description = description;
        this.objectVersion = objectVersion;
        this.objectStatus = objectStatus;
        this.identifier = identifier;
        this.primarySchema = primarySchema;
        this.connectionProperties = connectionProperties;
        this.isDefault = isDefault;
        this.metadata = metadata;
    }

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Schema getPrimarySchema() {
        return this.primarySchema;
    }

    public List<ConnectionProperty> getConnectionProperties() {
        return this.connectionProperties;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ConnectionDetails(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", objectVersion=").append(String.valueOf(this.objectVersion));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(", identifier=").append(String.valueOf(this.identifier));
        sb.append(", primarySchema=").append(String.valueOf((Object)this.primarySchema));
        sb.append(", connectionProperties=").append(String.valueOf(this.connectionProperties));
        sb.append(", isDefault=").append(String.valueOf(this.isDefault));
        sb.append(", metadata=").append(String.valueOf((Object)this.metadata));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectionDetails)) {
            return false;
        }
        ConnectionDetails other = (ConnectionDetails)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.objectVersion, other.objectVersion) && Objects.equals(this.objectStatus, other.objectStatus) && Objects.equals(this.identifier, other.identifier) && Objects.equals((Object)this.primarySchema, (Object)other.primarySchema) && Objects.equals(this.connectionProperties, other.connectionProperties) && Objects.equals(this.isDefault, other.isDefault) && Objects.equals((Object)this.metadata, (Object)other.metadata) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.objectVersion == null ? 43 : this.objectVersion.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.primarySchema == null ? 43 : this.primarySchema.hashCode());
        result = result * 59 + (this.connectionProperties == null ? 43 : this.connectionProperties.hashCode());
        result = result * 59 + (this.isDefault == null ? 43 : this.isDefault.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ModelType implements BmcEnum
    {
        OracleAdwcConnection("ORACLE_ADWC_CONNECTION"),
        OracleAtpConnection("ORACLE_ATP_CONNECTION"),
        OracleObjectStorageConnection("ORACLE_OBJECT_STORAGE_CONNECTION"),
        OracledbConnection("ORACLEDB_CONNECTION"),
        MysqlConnection("MYSQL_CONNECTION"),
        GenericJdbcConnection("GENERIC_JDBC_CONNECTION"),
        BiccConnection("BICC_CONNECTION"),
        AmazonS3Connection("AMAZON_S3_CONNECTION"),
        BipConnection("BIP_CONNECTION"),
        LakeConnection("LAKE_CONNECTION"),
        RestNoAuthConnection("REST_NO_AUTH_CONNECTION"),
        RestBasicAuthConnection("REST_BASIC_AUTH_CONNECTION");

        private final String value;
        private static Map<String, ModelType> map;

        private ModelType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ModelType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ModelType: " + key);
        }

        static {
            map = new HashMap<String, ModelType>();
            for (ModelType v : ModelType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

