/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateSourceApplicationInfo
extends ExplicitlySetBmcModel {
    @JsonProperty(value="workspaceId")
    private final String workspaceId;
    @JsonProperty(value="applicationKey")
    private final String applicationKey;
    @JsonProperty(value="copyType")
    private final CopyType copyType;

    @Deprecated
    @ConstructorProperties(value={"workspaceId", "applicationKey", "copyType"})
    public CreateSourceApplicationInfo(String workspaceId, String applicationKey, CopyType copyType) {
        this.workspaceId = workspaceId;
        this.applicationKey = applicationKey;
        this.copyType = copyType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public CopyType getCopyType() {
        return this.copyType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateSourceApplicationInfo(");
        sb.append("super=").append(super.toString());
        sb.append("workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(", applicationKey=").append(String.valueOf(this.applicationKey));
        sb.append(", copyType=").append(String.valueOf((Object)this.copyType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateSourceApplicationInfo)) {
            return false;
        }
        CreateSourceApplicationInfo other = (CreateSourceApplicationInfo)((Object)o);
        return Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.applicationKey, other.applicationKey) && Objects.equals((Object)this.copyType, (Object)other.copyType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.applicationKey == null ? 43 : this.applicationKey.hashCode());
        result = result * 59 + (this.copyType == null ? 43 : this.copyType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum CopyType implements BmcEnum
    {
        Connected("CONNECTED"),
        Disconnected("DISCONNECTED");

        private final String value;
        private static Map<String, CopyType> map;

        private CopyType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CopyType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid CopyType: " + key);
        }

        static {
            map = new HashMap<String, CopyType>();
            for (CopyType v : CopyType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="workspaceId")
        private String workspaceId;
        @JsonProperty(value="applicationKey")
        private String applicationKey;
        @JsonProperty(value="copyType")
        private CopyType copyType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            this.__explicitlySet__.add("workspaceId");
            return this;
        }

        public Builder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            this.__explicitlySet__.add("applicationKey");
            return this;
        }

        public Builder copyType(CopyType copyType) {
            this.copyType = copyType;
            this.__explicitlySet__.add("copyType");
            return this;
        }

        public CreateSourceApplicationInfo build() {
            CreateSourceApplicationInfo model = new CreateSourceApplicationInfo(this.workspaceId, this.applicationKey, this.copyType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateSourceApplicationInfo model) {
            if (model.wasPropertyExplicitlySet("workspaceId")) {
                this.workspaceId(model.getWorkspaceId());
            }
            if (model.wasPropertyExplicitlySet("applicationKey")) {
                this.applicationKey(model.getApplicationKey());
            }
            if (model.wasPropertyExplicitlySet("copyType")) {
                this.copyType(model.getCopyType());
            }
            return this;
        }
    }
}

