/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConditionalCompositeFieldMap;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.CreateConfigProvider;
import com.oracle.bmc.dataintegration.model.CreateTaskDetails;
import com.oracle.bmc.dataintegration.model.DataFlow;
import com.oracle.bmc.dataintegration.model.InputPort;
import com.oracle.bmc.dataintegration.model.OutputPort;
import com.oracle.bmc.dataintegration.model.Parameter;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.RegistryMetadata;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateTaskFromDataLoaderTask
extends CreateTaskDetails {
    @JsonProperty(value="dataFlow")
    private final DataFlow dataFlow;
    @JsonProperty(value="conditionalCompositeFieldMap")
    private final ConditionalCompositeFieldMap conditionalCompositeFieldMap;
    @JsonProperty(value="isSingleLoad")
    private final Boolean isSingleLoad;
    @JsonProperty(value="parallelLoadLimit")
    private final Integer parallelLoadLimit;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateTaskFromDataLoaderTask(String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectStatus, String identifier, List<InputPort> inputPorts, List<OutputPort> outputPorts, List<Parameter> parameters, ConfigValues opConfigValues, CreateConfigProvider configProviderDelegate, RegistryMetadata registryMetadata, DataFlow dataFlow, ConditionalCompositeFieldMap conditionalCompositeFieldMap, Boolean isSingleLoad, Integer parallelLoadLimit) {
        super(key, modelVersion, parentRef, name, description, objectStatus, identifier, inputPorts, outputPorts, parameters, opConfigValues, configProviderDelegate, registryMetadata);
        this.dataFlow = dataFlow;
        this.conditionalCompositeFieldMap = conditionalCompositeFieldMap;
        this.isSingleLoad = isSingleLoad;
        this.parallelLoadLimit = parallelLoadLimit;
    }

    public DataFlow getDataFlow() {
        return this.dataFlow;
    }

    public ConditionalCompositeFieldMap getConditionalCompositeFieldMap() {
        return this.conditionalCompositeFieldMap;
    }

    public Boolean getIsSingleLoad() {
        return this.isSingleLoad;
    }

    public Integer getParallelLoadLimit() {
        return this.parallelLoadLimit;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateTaskFromDataLoaderTask(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", dataFlow=").append(String.valueOf((Object)this.dataFlow));
        sb.append(", conditionalCompositeFieldMap=").append(String.valueOf((Object)this.conditionalCompositeFieldMap));
        sb.append(", isSingleLoad=").append(String.valueOf(this.isSingleLoad));
        sb.append(", parallelLoadLimit=").append(String.valueOf(this.parallelLoadLimit));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateTaskFromDataLoaderTask)) {
            return false;
        }
        CreateTaskFromDataLoaderTask other = (CreateTaskFromDataLoaderTask)((Object)o);
        return Objects.equals((Object)this.dataFlow, (Object)other.dataFlow) && Objects.equals((Object)this.conditionalCompositeFieldMap, (Object)other.conditionalCompositeFieldMap) && Objects.equals(this.isSingleLoad, other.isSingleLoad) && Objects.equals(this.parallelLoadLimit, other.parallelLoadLimit) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dataFlow == null ? 43 : this.dataFlow.hashCode());
        result = result * 59 + (this.conditionalCompositeFieldMap == null ? 43 : this.conditionalCompositeFieldMap.hashCode());
        result = result * 59 + (this.isSingleLoad == null ? 43 : this.isSingleLoad.hashCode());
        result = result * 59 + (this.parallelLoadLimit == null ? 43 : this.parallelLoadLimit.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="inputPorts")
        private List<InputPort> inputPorts;
        @JsonProperty(value="outputPorts")
        private List<OutputPort> outputPorts;
        @JsonProperty(value="parameters")
        private List<Parameter> parameters;
        @JsonProperty(value="opConfigValues")
        private ConfigValues opConfigValues;
        @JsonProperty(value="configProviderDelegate")
        private CreateConfigProvider configProviderDelegate;
        @JsonProperty(value="registryMetadata")
        private RegistryMetadata registryMetadata;
        @JsonProperty(value="dataFlow")
        private DataFlow dataFlow;
        @JsonProperty(value="conditionalCompositeFieldMap")
        private ConditionalCompositeFieldMap conditionalCompositeFieldMap;
        @JsonProperty(value="isSingleLoad")
        private Boolean isSingleLoad;
        @JsonProperty(value="parallelLoadLimit")
        private Integer parallelLoadLimit;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder inputPorts(List<InputPort> inputPorts) {
            this.inputPorts = inputPorts;
            this.__explicitlySet__.add("inputPorts");
            return this;
        }

        public Builder outputPorts(List<OutputPort> outputPorts) {
            this.outputPorts = outputPorts;
            this.__explicitlySet__.add("outputPorts");
            return this;
        }

        public Builder parameters(List<Parameter> parameters) {
            this.parameters = parameters;
            this.__explicitlySet__.add("parameters");
            return this;
        }

        public Builder opConfigValues(ConfigValues opConfigValues) {
            this.opConfigValues = opConfigValues;
            this.__explicitlySet__.add("opConfigValues");
            return this;
        }

        public Builder configProviderDelegate(CreateConfigProvider configProviderDelegate) {
            this.configProviderDelegate = configProviderDelegate;
            this.__explicitlySet__.add("configProviderDelegate");
            return this;
        }

        public Builder registryMetadata(RegistryMetadata registryMetadata) {
            this.registryMetadata = registryMetadata;
            this.__explicitlySet__.add("registryMetadata");
            return this;
        }

        public Builder dataFlow(DataFlow dataFlow) {
            this.dataFlow = dataFlow;
            this.__explicitlySet__.add("dataFlow");
            return this;
        }

        public Builder conditionalCompositeFieldMap(ConditionalCompositeFieldMap conditionalCompositeFieldMap) {
            this.conditionalCompositeFieldMap = conditionalCompositeFieldMap;
            this.__explicitlySet__.add("conditionalCompositeFieldMap");
            return this;
        }

        public Builder isSingleLoad(Boolean isSingleLoad) {
            this.isSingleLoad = isSingleLoad;
            this.__explicitlySet__.add("isSingleLoad");
            return this;
        }

        public Builder parallelLoadLimit(Integer parallelLoadLimit) {
            this.parallelLoadLimit = parallelLoadLimit;
            this.__explicitlySet__.add("parallelLoadLimit");
            return this;
        }

        public CreateTaskFromDataLoaderTask build() {
            CreateTaskFromDataLoaderTask model = new CreateTaskFromDataLoaderTask(this.key, this.modelVersion, this.parentRef, this.name, this.description, this.objectStatus, this.identifier, this.inputPorts, this.outputPorts, this.parameters, this.opConfigValues, this.configProviderDelegate, this.registryMetadata, this.dataFlow, this.conditionalCompositeFieldMap, this.isSingleLoad, this.parallelLoadLimit);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateTaskFromDataLoaderTask model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("inputPorts")) {
                this.inputPorts(model.getInputPorts());
            }
            if (model.wasPropertyExplicitlySet("outputPorts")) {
                this.outputPorts(model.getOutputPorts());
            }
            if (model.wasPropertyExplicitlySet("parameters")) {
                this.parameters(model.getParameters());
            }
            if (model.wasPropertyExplicitlySet("opConfigValues")) {
                this.opConfigValues(model.getOpConfigValues());
            }
            if (model.wasPropertyExplicitlySet("configProviderDelegate")) {
                this.configProviderDelegate(model.getConfigProviderDelegate());
            }
            if (model.wasPropertyExplicitlySet("registryMetadata")) {
                this.registryMetadata(model.getRegistryMetadata());
            }
            if (model.wasPropertyExplicitlySet("dataFlow")) {
                this.dataFlow(model.getDataFlow());
            }
            if (model.wasPropertyExplicitlySet("conditionalCompositeFieldMap")) {
                this.conditionalCompositeFieldMap(model.getConditionalCompositeFieldMap());
            }
            if (model.wasPropertyExplicitlySet("isSingleLoad")) {
                this.isSingleLoad(model.getIsSingleLoad());
            }
            if (model.wasPropertyExplicitlySet("parallelLoadLimit")) {
                this.parallelLoadLimit(model.getParallelLoadLimit());
            }
            return this;
        }
    }
}

