/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.CreateConfigProvider;
import com.oracle.bmc.dataintegration.model.CreateTaskDetails;
import com.oracle.bmc.dataintegration.model.InputPort;
import com.oracle.bmc.dataintegration.model.OutputPort;
import com.oracle.bmc.dataintegration.model.Parameter;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.RegistryMetadata;
import com.oracle.bmc.dataintegration.model.Script;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateTaskFromSQLTask
extends CreateTaskDetails {
    @JsonProperty(value="script")
    private final Script script;
    @JsonProperty(value="sqlScriptType")
    private final SqlScriptType sqlScriptType;
    @JsonProperty(value="operation")
    private final Object operation;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateTaskFromSQLTask(String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectStatus, String identifier, List<InputPort> inputPorts, List<OutputPort> outputPorts, List<Parameter> parameters, ConfigValues opConfigValues, CreateConfigProvider configProviderDelegate, RegistryMetadata registryMetadata, Script script, SqlScriptType sqlScriptType, Object operation) {
        super(key, modelVersion, parentRef, name, description, objectStatus, identifier, inputPorts, outputPorts, parameters, opConfigValues, configProviderDelegate, registryMetadata);
        this.script = script;
        this.sqlScriptType = sqlScriptType;
        this.operation = operation;
    }

    public Script getScript() {
        return this.script;
    }

    public SqlScriptType getSqlScriptType() {
        return this.sqlScriptType;
    }

    public Object getOperation() {
        return this.operation;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateTaskFromSQLTask(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", script=").append(String.valueOf((Object)this.script));
        sb.append(", sqlScriptType=").append(String.valueOf((Object)this.sqlScriptType));
        sb.append(", operation=").append(String.valueOf(this.operation));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateTaskFromSQLTask)) {
            return false;
        }
        CreateTaskFromSQLTask other = (CreateTaskFromSQLTask)((Object)o);
        return Objects.equals((Object)this.script, (Object)other.script) && Objects.equals((Object)this.sqlScriptType, (Object)other.sqlScriptType) && Objects.equals(this.operation, other.operation) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.script == null ? 43 : this.script.hashCode());
        result = result * 59 + (this.sqlScriptType == null ? 43 : this.sqlScriptType.hashCode());
        result = result * 59 + (this.operation == null ? 43 : this.operation.hashCode());
        return result;
    }

    public static enum SqlScriptType implements BmcEnum
    {
        StoredProcedure("STORED_PROCEDURE"),
        SqlCode("SQL_CODE");

        private final String value;
        private static Map<String, SqlScriptType> map;

        private SqlScriptType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SqlScriptType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SqlScriptType: " + key);
        }

        static {
            map = new HashMap<String, SqlScriptType>();
            for (SqlScriptType v : SqlScriptType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="inputPorts")
        private List<InputPort> inputPorts;
        @JsonProperty(value="outputPorts")
        private List<OutputPort> outputPorts;
        @JsonProperty(value="parameters")
        private List<Parameter> parameters;
        @JsonProperty(value="opConfigValues")
        private ConfigValues opConfigValues;
        @JsonProperty(value="configProviderDelegate")
        private CreateConfigProvider configProviderDelegate;
        @JsonProperty(value="registryMetadata")
        private RegistryMetadata registryMetadata;
        @JsonProperty(value="script")
        private Script script;
        @JsonProperty(value="sqlScriptType")
        private SqlScriptType sqlScriptType;
        @JsonProperty(value="operation")
        private Object operation;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder inputPorts(List<InputPort> inputPorts) {
            this.inputPorts = inputPorts;
            this.__explicitlySet__.add("inputPorts");
            return this;
        }

        public Builder outputPorts(List<OutputPort> outputPorts) {
            this.outputPorts = outputPorts;
            this.__explicitlySet__.add("outputPorts");
            return this;
        }

        public Builder parameters(List<Parameter> parameters) {
            this.parameters = parameters;
            this.__explicitlySet__.add("parameters");
            return this;
        }

        public Builder opConfigValues(ConfigValues opConfigValues) {
            this.opConfigValues = opConfigValues;
            this.__explicitlySet__.add("opConfigValues");
            return this;
        }

        public Builder configProviderDelegate(CreateConfigProvider configProviderDelegate) {
            this.configProviderDelegate = configProviderDelegate;
            this.__explicitlySet__.add("configProviderDelegate");
            return this;
        }

        public Builder registryMetadata(RegistryMetadata registryMetadata) {
            this.registryMetadata = registryMetadata;
            this.__explicitlySet__.add("registryMetadata");
            return this;
        }

        public Builder script(Script script) {
            this.script = script;
            this.__explicitlySet__.add("script");
            return this;
        }

        public Builder sqlScriptType(SqlScriptType sqlScriptType) {
            this.sqlScriptType = sqlScriptType;
            this.__explicitlySet__.add("sqlScriptType");
            return this;
        }

        public Builder operation(Object operation) {
            this.operation = operation;
            this.__explicitlySet__.add("operation");
            return this;
        }

        public CreateTaskFromSQLTask build() {
            CreateTaskFromSQLTask model = new CreateTaskFromSQLTask(this.key, this.modelVersion, this.parentRef, this.name, this.description, this.objectStatus, this.identifier, this.inputPorts, this.outputPorts, this.parameters, this.opConfigValues, this.configProviderDelegate, this.registryMetadata, this.script, this.sqlScriptType, this.operation);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateTaskFromSQLTask model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("inputPorts")) {
                this.inputPorts(model.getInputPorts());
            }
            if (model.wasPropertyExplicitlySet("outputPorts")) {
                this.outputPorts(model.getOutputPorts());
            }
            if (model.wasPropertyExplicitlySet("parameters")) {
                this.parameters(model.getParameters());
            }
            if (model.wasPropertyExplicitlySet("opConfigValues")) {
                this.opConfigValues(model.getOpConfigValues());
            }
            if (model.wasPropertyExplicitlySet("configProviderDelegate")) {
                this.configProviderDelegate(model.getConfigProviderDelegate());
            }
            if (model.wasPropertyExplicitlySet("registryMetadata")) {
                this.registryMetadata(model.getRegistryMetadata());
            }
            if (model.wasPropertyExplicitlySet("script")) {
                this.script(model.getScript());
            }
            if (model.wasPropertyExplicitlySet("sqlScriptType")) {
                this.sqlScriptType(model.getSqlScriptType());
            }
            if (model.wasPropertyExplicitlySet("operation")) {
                this.operation(model.getOperation());
            }
            return this;
        }
    }
}

