/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dataintegration.model.DataAssetFromAdwcDetails;
import com.oracle.bmc.dataintegration.model.DataAssetFromAmazonS3;
import com.oracle.bmc.dataintegration.model.DataAssetFromAtpDetails;
import com.oracle.bmc.dataintegration.model.DataAssetFromFusionApp;
import com.oracle.bmc.dataintegration.model.DataAssetFromJdbc;
import com.oracle.bmc.dataintegration.model.DataAssetFromLakeDetails;
import com.oracle.bmc.dataintegration.model.DataAssetFromMySQL;
import com.oracle.bmc.dataintegration.model.DataAssetFromObjectStorageDetails;
import com.oracle.bmc.dataintegration.model.DataAssetFromOracleDetails;
import com.oracle.bmc.dataintegration.model.DataAssetFromRestDetails;
import com.oracle.bmc.dataintegration.model.ObjectMetadata;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.TypeSystem;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType", defaultImpl=DataAsset.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=DataAssetFromJdbc.class, name="GENERIC_JDBC_DATA_ASSET"), @JsonSubTypes.Type(value=DataAssetFromOracleDetails.class, name="ORACLE_DATA_ASSET"), @JsonSubTypes.Type(value=DataAssetFromAdwcDetails.class, name="ORACLE_ADWC_DATA_ASSET"), @JsonSubTypes.Type(value=DataAssetFromAmazonS3.class, name="AMAZON_S3_DATA_ASSET"), @JsonSubTypes.Type(value=DataAssetFromObjectStorageDetails.class, name="ORACLE_OBJECT_STORAGE_DATA_ASSET"), @JsonSubTypes.Type(value=DataAssetFromFusionApp.class, name="FUSION_APP_DATA_ASSET"), @JsonSubTypes.Type(value=DataAssetFromLakeDetails.class, name="LAKE_DATA_ASSET"), @JsonSubTypes.Type(value=DataAssetFromAtpDetails.class, name="ORACLE_ATP_DATA_ASSET"), @JsonSubTypes.Type(value=DataAssetFromMySQL.class, name="MYSQL_DATA_ASSET"), @JsonSubTypes.Type(value=DataAssetFromRestDetails.class, name="REST_DATA_ASSET")})
@JsonFilter(value="explicitlySetFilter")
public class DataAsset
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="externalKey")
    private final String externalKey;
    @JsonProperty(value="assetProperties")
    private final Map<String, String> assetProperties;
    @JsonProperty(value="nativeTypeSystem")
    private final TypeSystem nativeTypeSystem;
    @JsonProperty(value="objectVersion")
    private final Integer objectVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="metadata")
    private final ObjectMetadata metadata;
    @JsonProperty(value="keyMap")
    private final Map<String, String> keyMap;

    @Deprecated
    @ConstructorProperties(value={"key", "modelVersion", "name", "description", "objectStatus", "identifier", "externalKey", "assetProperties", "nativeTypeSystem", "objectVersion", "parentRef", "metadata", "keyMap"})
    protected DataAsset(String key, String modelVersion, String name, String description, Integer objectStatus, String identifier, String externalKey, Map<String, String> assetProperties, TypeSystem nativeTypeSystem, Integer objectVersion, ParentReference parentRef, ObjectMetadata metadata, Map<String, String> keyMap) {
        this.key = key;
        this.modelVersion = modelVersion;
        this.name = name;
        this.description = description;
        this.objectStatus = objectStatus;
        this.identifier = identifier;
        this.externalKey = externalKey;
        this.assetProperties = assetProperties;
        this.nativeTypeSystem = nativeTypeSystem;
        this.objectVersion = objectVersion;
        this.parentRef = parentRef;
        this.metadata = metadata;
        this.keyMap = keyMap;
    }

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public Map<String, String> getAssetProperties() {
        return this.assetProperties;
    }

    public TypeSystem getNativeTypeSystem() {
        return this.nativeTypeSystem;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public Map<String, String> getKeyMap() {
        return this.keyMap;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DataAsset(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(", identifier=").append(String.valueOf(this.identifier));
        sb.append(", externalKey=").append(String.valueOf(this.externalKey));
        sb.append(", assetProperties=").append(String.valueOf(this.assetProperties));
        sb.append(", nativeTypeSystem=").append(String.valueOf((Object)this.nativeTypeSystem));
        sb.append(", objectVersion=").append(String.valueOf(this.objectVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", metadata=").append(String.valueOf((Object)this.metadata));
        sb.append(", keyMap=").append(String.valueOf(this.keyMap));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataAsset)) {
            return false;
        }
        DataAsset other = (DataAsset)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.objectStatus, other.objectStatus) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.externalKey, other.externalKey) && Objects.equals(this.assetProperties, other.assetProperties) && Objects.equals((Object)this.nativeTypeSystem, (Object)other.nativeTypeSystem) && Objects.equals(this.objectVersion, other.objectVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals((Object)this.metadata, (Object)other.metadata) && Objects.equals(this.keyMap, other.keyMap) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.externalKey == null ? 43 : this.externalKey.hashCode());
        result = result * 59 + (this.assetProperties == null ? 43 : this.assetProperties.hashCode());
        result = result * 59 + (this.nativeTypeSystem == null ? 43 : this.nativeTypeSystem.hashCode());
        result = result * 59 + (this.objectVersion == null ? 43 : this.objectVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + (this.keyMap == null ? 43 : this.keyMap.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ModelType implements BmcEnum
    {
        OracleDataAsset("ORACLE_DATA_ASSET"),
        OracleObjectStorageDataAsset("ORACLE_OBJECT_STORAGE_DATA_ASSET"),
        OracleAtpDataAsset("ORACLE_ATP_DATA_ASSET"),
        OracleAdwcDataAsset("ORACLE_ADWC_DATA_ASSET"),
        MysqlDataAsset("MYSQL_DATA_ASSET"),
        GenericJdbcDataAsset("GENERIC_JDBC_DATA_ASSET"),
        FusionAppDataAsset("FUSION_APP_DATA_ASSET"),
        AmazonS3DataAsset("AMAZON_S3_DATA_ASSET"),
        LakeDataAsset("LAKE_DATA_ASSET"),
        RestDataAsset("REST_DATA_ASSET"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ModelType> map;

        private ModelType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ModelType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ModelType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ModelType.class);
            map = new HashMap<String, ModelType>();
            for (ModelType v : ModelType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

