/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.BaseType;
import com.oracle.bmc.dataintegration.model.ParentReference;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class MapType
extends BaseType {
    @JsonProperty(value="keyElementType")
    private final String keyElementType;
    @JsonProperty(value="valueElementType")
    private final String valueElementType;
    @JsonProperty(value="containsNull")
    private final Boolean containsNull;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public MapType(String key, String modelVersion, ParentReference parentRef, String name, Integer objectStatus, String description, String keyElementType, String valueElementType, Boolean containsNull) {
        super(key, modelVersion, parentRef, name, objectStatus, description);
        this.keyElementType = keyElementType;
        this.valueElementType = valueElementType;
        this.containsNull = containsNull;
    }

    public String getKeyElementType() {
        return this.keyElementType;
    }

    public String getValueElementType() {
        return this.valueElementType;
    }

    public Boolean getContainsNull() {
        return this.containsNull;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MapType(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", keyElementType=").append(String.valueOf(this.keyElementType));
        sb.append(", valueElementType=").append(String.valueOf(this.valueElementType));
        sb.append(", containsNull=").append(String.valueOf(this.containsNull));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MapType)) {
            return false;
        }
        MapType other = (MapType)((Object)o);
        return Objects.equals(this.keyElementType, other.keyElementType) && Objects.equals(this.valueElementType, other.valueElementType) && Objects.equals(this.containsNull, other.containsNull) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.keyElementType == null ? 43 : this.keyElementType.hashCode());
        result = result * 59 + (this.valueElementType == null ? 43 : this.valueElementType.hashCode());
        result = result * 59 + (this.containsNull == null ? 43 : this.containsNull.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="keyElementType")
        private String keyElementType;
        @JsonProperty(value="valueElementType")
        private String valueElementType;
        @JsonProperty(value="containsNull")
        private Boolean containsNull;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder keyElementType(String keyElementType) {
            this.keyElementType = keyElementType;
            this.__explicitlySet__.add("keyElementType");
            return this;
        }

        public Builder valueElementType(String valueElementType) {
            this.valueElementType = valueElementType;
            this.__explicitlySet__.add("valueElementType");
            return this;
        }

        public Builder containsNull(Boolean containsNull) {
            this.containsNull = containsNull;
            this.__explicitlySet__.add("containsNull");
            return this;
        }

        public MapType build() {
            MapType model = new MapType(this.key, this.modelVersion, this.parentRef, this.name, this.objectStatus, this.description, this.keyElementType, this.valueElementType, this.containsNull);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MapType model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("keyElementType")) {
                this.keyElementType(model.getKeyElementType());
            }
            if (model.wasPropertyExplicitlySet("valueElementType")) {
                this.valueElementType(model.getValueElementType());
            }
            if (model.wasPropertyExplicitlySet("containsNull")) {
                this.containsNull(model.getContainsNull());
            }
            return this;
        }
    }
}

