/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigDefinition;
import com.oracle.bmc.dataintegration.model.FunctionConfigurationDefinition;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.Shape;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OciFunction
extends ExplicitlySetBmcModel {
    @JsonProperty(value="functionId")
    private final String functionId;
    @JsonProperty(value="regionId")
    private final String regionId;
    @JsonProperty(value="fnConfigDefinition")
    private final ConfigDefinition fnConfigDefinition;
    @JsonProperty(value="inputShape")
    private final Shape inputShape;
    @JsonProperty(value="outputShape")
    private final Shape outputShape;
    @JsonProperty(value="modelType")
    private final ModelType modelType;
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="objectVersion")
    private final Integer objectVersion;
    @JsonProperty(value="payloadFormat")
    private final PayloadFormat payloadFormat;
    @JsonProperty(value="fnConfigDef")
    private final FunctionConfigurationDefinition fnConfigDef;

    @Deprecated
    @ConstructorProperties(value={"functionId", "regionId", "fnConfigDefinition", "inputShape", "outputShape", "modelType", "key", "parentRef", "modelVersion", "objectVersion", "payloadFormat", "fnConfigDef"})
    public OciFunction(String functionId, String regionId, ConfigDefinition fnConfigDefinition, Shape inputShape, Shape outputShape, ModelType modelType, String key, ParentReference parentRef, String modelVersion, Integer objectVersion, PayloadFormat payloadFormat, FunctionConfigurationDefinition fnConfigDef) {
        this.functionId = functionId;
        this.regionId = regionId;
        this.fnConfigDefinition = fnConfigDefinition;
        this.inputShape = inputShape;
        this.outputShape = outputShape;
        this.modelType = modelType;
        this.key = key;
        this.parentRef = parentRef;
        this.modelVersion = modelVersion;
        this.objectVersion = objectVersion;
        this.payloadFormat = payloadFormat;
        this.fnConfigDef = fnConfigDef;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getFunctionId() {
        return this.functionId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public ConfigDefinition getFnConfigDefinition() {
        return this.fnConfigDefinition;
    }

    public Shape getInputShape() {
        return this.inputShape;
    }

    public Shape getOutputShape() {
        return this.outputShape;
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    public String getKey() {
        return this.key;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public PayloadFormat getPayloadFormat() {
        return this.payloadFormat;
    }

    public FunctionConfigurationDefinition getFnConfigDef() {
        return this.fnConfigDef;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OciFunction(");
        sb.append("super=").append(super.toString());
        sb.append("functionId=").append(String.valueOf(this.functionId));
        sb.append(", regionId=").append(String.valueOf(this.regionId));
        sb.append(", fnConfigDefinition=").append(String.valueOf((Object)this.fnConfigDefinition));
        sb.append(", inputShape=").append(String.valueOf((Object)this.inputShape));
        sb.append(", outputShape=").append(String.valueOf((Object)this.outputShape));
        sb.append(", modelType=").append(String.valueOf((Object)this.modelType));
        sb.append(", key=").append(String.valueOf(this.key));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", objectVersion=").append(String.valueOf(this.objectVersion));
        sb.append(", payloadFormat=").append(String.valueOf((Object)this.payloadFormat));
        sb.append(", fnConfigDef=").append(String.valueOf((Object)this.fnConfigDef));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OciFunction)) {
            return false;
        }
        OciFunction other = (OciFunction)((Object)o);
        return Objects.equals(this.functionId, other.functionId) && Objects.equals(this.regionId, other.regionId) && Objects.equals((Object)this.fnConfigDefinition, (Object)other.fnConfigDefinition) && Objects.equals((Object)this.inputShape, (Object)other.inputShape) && Objects.equals((Object)this.outputShape, (Object)other.outputShape) && Objects.equals((Object)this.modelType, (Object)other.modelType) && Objects.equals(this.key, other.key) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals(this.objectVersion, other.objectVersion) && Objects.equals((Object)this.payloadFormat, (Object)other.payloadFormat) && Objects.equals((Object)this.fnConfigDef, (Object)other.fnConfigDef) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.functionId == null ? 43 : this.functionId.hashCode());
        result = result * 59 + (this.regionId == null ? 43 : this.regionId.hashCode());
        result = result * 59 + (this.fnConfigDefinition == null ? 43 : this.fnConfigDefinition.hashCode());
        result = result * 59 + (this.inputShape == null ? 43 : this.inputShape.hashCode());
        result = result * 59 + (this.outputShape == null ? 43 : this.outputShape.hashCode());
        result = result * 59 + (this.modelType == null ? 43 : this.modelType.hashCode());
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.objectVersion == null ? 43 : this.objectVersion.hashCode());
        result = result * 59 + (this.payloadFormat == null ? 43 : this.payloadFormat.hashCode());
        result = result * 59 + (this.fnConfigDef == null ? 43 : this.fnConfigDef.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum PayloadFormat implements BmcEnum
    {
        Json("JSON"),
        Avro("AVRO"),
        Jsonbytes("JSONBYTES"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PayloadFormat> map;

        private PayloadFormat(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PayloadFormat create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PayloadFormat', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PayloadFormat.class);
            map = new HashMap<String, PayloadFormat>();
            for (PayloadFormat v : PayloadFormat.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ModelType implements BmcEnum
    {
        OciFunction("OCI_FUNCTION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ModelType> map;

        private ModelType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ModelType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ModelType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ModelType.class);
            map = new HashMap<String, ModelType>();
            for (ModelType v : ModelType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="functionId")
        private String functionId;
        @JsonProperty(value="regionId")
        private String regionId;
        @JsonProperty(value="fnConfigDefinition")
        private ConfigDefinition fnConfigDefinition;
        @JsonProperty(value="inputShape")
        private Shape inputShape;
        @JsonProperty(value="outputShape")
        private Shape outputShape;
        @JsonProperty(value="modelType")
        private ModelType modelType;
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="payloadFormat")
        private PayloadFormat payloadFormat;
        @JsonProperty(value="fnConfigDef")
        private FunctionConfigurationDefinition fnConfigDef;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder functionId(String functionId) {
            this.functionId = functionId;
            this.__explicitlySet__.add("functionId");
            return this;
        }

        public Builder regionId(String regionId) {
            this.regionId = regionId;
            this.__explicitlySet__.add("regionId");
            return this;
        }

        public Builder fnConfigDefinition(ConfigDefinition fnConfigDefinition) {
            this.fnConfigDefinition = fnConfigDefinition;
            this.__explicitlySet__.add("fnConfigDefinition");
            return this;
        }

        public Builder inputShape(Shape inputShape) {
            this.inputShape = inputShape;
            this.__explicitlySet__.add("inputShape");
            return this;
        }

        public Builder outputShape(Shape outputShape) {
            this.outputShape = outputShape;
            this.__explicitlySet__.add("outputShape");
            return this;
        }

        public Builder modelType(ModelType modelType) {
            this.modelType = modelType;
            this.__explicitlySet__.add("modelType");
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder payloadFormat(PayloadFormat payloadFormat) {
            this.payloadFormat = payloadFormat;
            this.__explicitlySet__.add("payloadFormat");
            return this;
        }

        public Builder fnConfigDef(FunctionConfigurationDefinition fnConfigDef) {
            this.fnConfigDef = fnConfigDef;
            this.__explicitlySet__.add("fnConfigDef");
            return this;
        }

        public OciFunction build() {
            OciFunction model = new OciFunction(this.functionId, this.regionId, this.fnConfigDefinition, this.inputShape, this.outputShape, this.modelType, this.key, this.parentRef, this.modelVersion, this.objectVersion, this.payloadFormat, this.fnConfigDef);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OciFunction model) {
            if (model.wasPropertyExplicitlySet("functionId")) {
                this.functionId(model.getFunctionId());
            }
            if (model.wasPropertyExplicitlySet("regionId")) {
                this.regionId(model.getRegionId());
            }
            if (model.wasPropertyExplicitlySet("fnConfigDefinition")) {
                this.fnConfigDefinition(model.getFnConfigDefinition());
            }
            if (model.wasPropertyExplicitlySet("inputShape")) {
                this.inputShape(model.getInputShape());
            }
            if (model.wasPropertyExplicitlySet("outputShape")) {
                this.outputShape(model.getOutputShape());
            }
            if (model.wasPropertyExplicitlySet("modelType")) {
                this.modelType(model.getModelType());
            }
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("payloadFormat")) {
                this.payloadFormat(model.getPayloadFormat());
            }
            if (model.wasPropertyExplicitlySet("fnConfigDef")) {
                this.fnConfigDef(model.getFnConfigDef());
            }
            return this;
        }
    }
}

