/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dataintegration.model.Aggregator;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.DecisionOperator;
import com.oracle.bmc.dataintegration.model.Distinct;
import com.oracle.bmc.dataintegration.model.EndOperator;
import com.oracle.bmc.dataintegration.model.ExpressionOperator;
import com.oracle.bmc.dataintegration.model.Filter;
import com.oracle.bmc.dataintegration.model.Flatten;
import com.oracle.bmc.dataintegration.model.Function;
import com.oracle.bmc.dataintegration.model.InputPort;
import com.oracle.bmc.dataintegration.model.Intersect;
import com.oracle.bmc.dataintegration.model.Joiner;
import com.oracle.bmc.dataintegration.model.Lookup;
import com.oracle.bmc.dataintegration.model.MergeOperator;
import com.oracle.bmc.dataintegration.model.Minus;
import com.oracle.bmc.dataintegration.model.Parameter;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.Pivot;
import com.oracle.bmc.dataintegration.model.Projection;
import com.oracle.bmc.dataintegration.model.SortOper;
import com.oracle.bmc.dataintegration.model.Source;
import com.oracle.bmc.dataintegration.model.Split;
import com.oracle.bmc.dataintegration.model.StartOperator;
import com.oracle.bmc.dataintegration.model.Target;
import com.oracle.bmc.dataintegration.model.TaskOperator;
import com.oracle.bmc.dataintegration.model.TypedObject;
import com.oracle.bmc.dataintegration.model.Union;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType", defaultImpl=Operator.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Joiner.class, name="JOINER_OPERATOR"), @JsonSubTypes.Type(value=TaskOperator.class, name="TASK_OPERATOR"), @JsonSubTypes.Type(value=Flatten.class, name="FLATTEN_OPERATOR"), @JsonSubTypes.Type(value=Aggregator.class, name="AGGREGATOR_OPERATOR"), @JsonSubTypes.Type(value=SortOper.class, name="SORT_OPERATOR"), @JsonSubTypes.Type(value=Projection.class, name="PROJECTION_OPERATOR"), @JsonSubTypes.Type(value=EndOperator.class, name="END_OPERATOR"), @JsonSubTypes.Type(value=Source.class, name="SOURCE_OPERATOR"), @JsonSubTypes.Type(value=Union.class, name="UNION_OPERATOR"), @JsonSubTypes.Type(value=ExpressionOperator.class, name="EXPRESSION_OPERATOR"), @JsonSubTypes.Type(value=Function.class, name="FUNCTION_OPERATOR"), @JsonSubTypes.Type(value=DecisionOperator.class, name="DECISION_OPERATOR"), @JsonSubTypes.Type(value=Intersect.class, name="INTERSECT_OPERATOR"), @JsonSubTypes.Type(value=Target.class, name="TARGET_OPERATOR"), @JsonSubTypes.Type(value=Distinct.class, name="DISTINCT_OPERATOR"), @JsonSubTypes.Type(value=Filter.class, name="FILTER_OPERATOR"), @JsonSubTypes.Type(value=Lookup.class, name="LOOKUP_OPERATOR"), @JsonSubTypes.Type(value=Pivot.class, name="PIVOT_OPERATOR"), @JsonSubTypes.Type(value=StartOperator.class, name="START_OPERATOR"), @JsonSubTypes.Type(value=MergeOperator.class, name="MERGE_OPERATOR"), @JsonSubTypes.Type(value=Split.class, name="SPLIT_OPERATOR"), @JsonSubTypes.Type(value=Minus.class, name="MINUS_OPERATOR")})
@JsonFilter(value="explicitlySetFilter")
public class Operator
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="objectVersion")
    private final Integer objectVersion;
    @JsonProperty(value="inputPorts")
    private final List<InputPort> inputPorts;
    @JsonProperty(value="outputPorts")
    private final List<TypedObject> outputPorts;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="parameters")
    private final List<Parameter> parameters;
    @JsonProperty(value="opConfigValues")
    private final ConfigValues opConfigValues;

    @Deprecated
    @ConstructorProperties(value={"key", "modelVersion", "parentRef", "name", "description", "objectVersion", "inputPorts", "outputPorts", "objectStatus", "identifier", "parameters", "opConfigValues"})
    protected Operator(String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectVersion, List<InputPort> inputPorts, List<TypedObject> outputPorts, Integer objectStatus, String identifier, List<Parameter> parameters, ConfigValues opConfigValues) {
        this.key = key;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.name = name;
        this.description = description;
        this.objectVersion = objectVersion;
        this.inputPorts = inputPorts;
        this.outputPorts = outputPorts;
        this.objectStatus = objectStatus;
        this.identifier = identifier;
        this.parameters = parameters;
        this.opConfigValues = opConfigValues;
    }

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public List<InputPort> getInputPorts() {
        return this.inputPorts;
    }

    public List<TypedObject> getOutputPorts() {
        return this.outputPorts;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public ConfigValues getOpConfigValues() {
        return this.opConfigValues;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Operator(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", objectVersion=").append(String.valueOf(this.objectVersion));
        sb.append(", inputPorts=").append(String.valueOf(this.inputPorts));
        sb.append(", outputPorts=").append(String.valueOf(this.outputPorts));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(", identifier=").append(String.valueOf(this.identifier));
        sb.append(", parameters=").append(String.valueOf(this.parameters));
        sb.append(", opConfigValues=").append(String.valueOf((Object)this.opConfigValues));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Operator)) {
            return false;
        }
        Operator other = (Operator)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.objectVersion, other.objectVersion) && Objects.equals(this.inputPorts, other.inputPorts) && Objects.equals(this.outputPorts, other.outputPorts) && Objects.equals(this.objectStatus, other.objectStatus) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.parameters, other.parameters) && Objects.equals((Object)this.opConfigValues, (Object)other.opConfigValues) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.objectVersion == null ? 43 : this.objectVersion.hashCode());
        result = result * 59 + (this.inputPorts == null ? 43 : this.inputPorts.hashCode());
        result = result * 59 + (this.outputPorts == null ? 43 : this.outputPorts.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.parameters == null ? 43 : this.parameters.hashCode());
        result = result * 59 + (this.opConfigValues == null ? 43 : this.opConfigValues.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ModelType implements BmcEnum
    {
        SourceOperator("SOURCE_OPERATOR"),
        FilterOperator("FILTER_OPERATOR"),
        JoinerOperator("JOINER_OPERATOR"),
        AggregatorOperator("AGGREGATOR_OPERATOR"),
        ProjectionOperator("PROJECTION_OPERATOR"),
        TargetOperator("TARGET_OPERATOR"),
        FlattenOperator("FLATTEN_OPERATOR"),
        DistinctOperator("DISTINCT_OPERATOR"),
        SortOperator("SORT_OPERATOR"),
        UnionOperator("UNION_OPERATOR"),
        IntersectOperator("INTERSECT_OPERATOR"),
        MinusOperator("MINUS_OPERATOR"),
        MergeOperator("MERGE_OPERATOR"),
        FunctionOperator("FUNCTION_OPERATOR"),
        SplitOperator("SPLIT_OPERATOR"),
        StartOperator("START_OPERATOR"),
        EndOperator("END_OPERATOR"),
        PipelineOperator("PIPELINE_OPERATOR"),
        DecisionOperator("DECISION_OPERATOR"),
        TaskOperator("TASK_OPERATOR"),
        ExpressionOperator("EXPRESSION_OPERATOR"),
        LookupOperator("LOOKUP_OPERATOR"),
        PivotOperator("PIVOT_OPERATOR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ModelType> map;

        private ModelType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ModelType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ModelType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ModelType.class);
            map = new HashMap<String, ModelType>();
            for (ModelType v : ModelType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

