/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.AuthConfig;
import com.oracle.bmc.dataintegration.model.AuthDetails;
import com.oracle.bmc.dataintegration.model.CancelRestCallConfig;
import com.oracle.bmc.dataintegration.model.ConfigProvider;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.ExecuteRestCallConfig;
import com.oracle.bmc.dataintegration.model.Expression;
import com.oracle.bmc.dataintegration.model.InputPort;
import com.oracle.bmc.dataintegration.model.ObjectMetadata;
import com.oracle.bmc.dataintegration.model.OutputPort;
import com.oracle.bmc.dataintegration.model.Parameter;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.PollRestCallConfig;
import com.oracle.bmc.dataintegration.model.TaskSummary;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class TaskSummaryFromRestTask
extends TaskSummary {
    @JsonProperty(value="authDetails")
    private final AuthDetails authDetails;
    @JsonProperty(value="authConfig")
    private final AuthConfig authConfig;
    @JsonProperty(value="endpoint")
    private final Expression endpoint;
    @JsonProperty(value="methodType")
    private final MethodType methodType;
    @JsonProperty(value="headers")
    private final Object headers;
    @JsonProperty(value="jsonData")
    private final String jsonData;
    @JsonProperty(value="apiCallMode")
    private final ApiCallMode apiCallMode;
    @JsonProperty(value="cancelEndpoint")
    private final Expression cancelEndpoint;
    @JsonProperty(value="cancelMethodType")
    private final CancelMethodType cancelMethodType;
    @JsonProperty(value="executeRestCallConfig")
    private final ExecuteRestCallConfig executeRestCallConfig;
    @JsonProperty(value="cancelRestCallConfig")
    private final CancelRestCallConfig cancelRestCallConfig;
    @JsonProperty(value="pollRestCallConfig")
    private final PollRestCallConfig pollRestCallConfig;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public TaskSummaryFromRestTask(String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectVersion, Integer objectStatus, String identifier, List<InputPort> inputPorts, List<OutputPort> outputPorts, List<Parameter> parameters, ConfigValues opConfigValues, ConfigProvider configProviderDelegate, ObjectMetadata metadata, Map<String, String> keyMap, AuthDetails authDetails, AuthConfig authConfig, Expression endpoint, MethodType methodType, Object headers, String jsonData, ApiCallMode apiCallMode, Expression cancelEndpoint, CancelMethodType cancelMethodType, ExecuteRestCallConfig executeRestCallConfig, CancelRestCallConfig cancelRestCallConfig, PollRestCallConfig pollRestCallConfig) {
        super(key, modelVersion, parentRef, name, description, objectVersion, objectStatus, identifier, inputPorts, outputPorts, parameters, opConfigValues, configProviderDelegate, metadata, keyMap);
        this.authDetails = authDetails;
        this.authConfig = authConfig;
        this.endpoint = endpoint;
        this.methodType = methodType;
        this.headers = headers;
        this.jsonData = jsonData;
        this.apiCallMode = apiCallMode;
        this.cancelEndpoint = cancelEndpoint;
        this.cancelMethodType = cancelMethodType;
        this.executeRestCallConfig = executeRestCallConfig;
        this.cancelRestCallConfig = cancelRestCallConfig;
        this.pollRestCallConfig = pollRestCallConfig;
    }

    public AuthDetails getAuthDetails() {
        return this.authDetails;
    }

    public AuthConfig getAuthConfig() {
        return this.authConfig;
    }

    public Expression getEndpoint() {
        return this.endpoint;
    }

    public MethodType getMethodType() {
        return this.methodType;
    }

    public Object getHeaders() {
        return this.headers;
    }

    public String getJsonData() {
        return this.jsonData;
    }

    public ApiCallMode getApiCallMode() {
        return this.apiCallMode;
    }

    public Expression getCancelEndpoint() {
        return this.cancelEndpoint;
    }

    public CancelMethodType getCancelMethodType() {
        return this.cancelMethodType;
    }

    public ExecuteRestCallConfig getExecuteRestCallConfig() {
        return this.executeRestCallConfig;
    }

    public CancelRestCallConfig getCancelRestCallConfig() {
        return this.cancelRestCallConfig;
    }

    public PollRestCallConfig getPollRestCallConfig() {
        return this.pollRestCallConfig;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TaskSummaryFromRestTask(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", authDetails=").append(String.valueOf((Object)this.authDetails));
        sb.append(", authConfig=").append(String.valueOf((Object)this.authConfig));
        sb.append(", endpoint=").append(String.valueOf((Object)this.endpoint));
        sb.append(", methodType=").append(String.valueOf((Object)this.methodType));
        sb.append(", headers=").append(String.valueOf(this.headers));
        sb.append(", jsonData=").append(String.valueOf(this.jsonData));
        sb.append(", apiCallMode=").append(String.valueOf((Object)this.apiCallMode));
        sb.append(", cancelEndpoint=").append(String.valueOf((Object)this.cancelEndpoint));
        sb.append(", cancelMethodType=").append(String.valueOf((Object)this.cancelMethodType));
        sb.append(", executeRestCallConfig=").append(String.valueOf((Object)this.executeRestCallConfig));
        sb.append(", cancelRestCallConfig=").append(String.valueOf((Object)this.cancelRestCallConfig));
        sb.append(", pollRestCallConfig=").append(String.valueOf((Object)this.pollRestCallConfig));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskSummaryFromRestTask)) {
            return false;
        }
        TaskSummaryFromRestTask other = (TaskSummaryFromRestTask)((Object)o);
        return Objects.equals((Object)this.authDetails, (Object)other.authDetails) && Objects.equals((Object)this.authConfig, (Object)other.authConfig) && Objects.equals((Object)this.endpoint, (Object)other.endpoint) && Objects.equals((Object)this.methodType, (Object)other.methodType) && Objects.equals(this.headers, other.headers) && Objects.equals(this.jsonData, other.jsonData) && Objects.equals((Object)this.apiCallMode, (Object)other.apiCallMode) && Objects.equals((Object)this.cancelEndpoint, (Object)other.cancelEndpoint) && Objects.equals((Object)this.cancelMethodType, (Object)other.cancelMethodType) && Objects.equals((Object)this.executeRestCallConfig, (Object)other.executeRestCallConfig) && Objects.equals((Object)this.cancelRestCallConfig, (Object)other.cancelRestCallConfig) && Objects.equals((Object)this.pollRestCallConfig, (Object)other.pollRestCallConfig) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.authDetails == null ? 43 : this.authDetails.hashCode());
        result = result * 59 + (this.authConfig == null ? 43 : this.authConfig.hashCode());
        result = result * 59 + (this.endpoint == null ? 43 : this.endpoint.hashCode());
        result = result * 59 + (this.methodType == null ? 43 : this.methodType.hashCode());
        result = result * 59 + (this.headers == null ? 43 : this.headers.hashCode());
        result = result * 59 + (this.jsonData == null ? 43 : this.jsonData.hashCode());
        result = result * 59 + (this.apiCallMode == null ? 43 : this.apiCallMode.hashCode());
        result = result * 59 + (this.cancelEndpoint == null ? 43 : this.cancelEndpoint.hashCode());
        result = result * 59 + (this.cancelMethodType == null ? 43 : this.cancelMethodType.hashCode());
        result = result * 59 + (this.executeRestCallConfig == null ? 43 : this.executeRestCallConfig.hashCode());
        result = result * 59 + (this.cancelRestCallConfig == null ? 43 : this.cancelRestCallConfig.hashCode());
        result = result * 59 + (this.pollRestCallConfig == null ? 43 : this.pollRestCallConfig.hashCode());
        return result;
    }

    public static enum CancelMethodType implements BmcEnum
    {
        Get("GET"),
        Post("POST"),
        Patch("PATCH"),
        Delete("DELETE"),
        Put("PUT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, CancelMethodType> map;

        private CancelMethodType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CancelMethodType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'CancelMethodType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(CancelMethodType.class);
            map = new HashMap<String, CancelMethodType>();
            for (CancelMethodType v : CancelMethodType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ApiCallMode implements BmcEnum
    {
        Synchronous("SYNCHRONOUS"),
        AsyncOciWorkrequest("ASYNC_OCI_WORKREQUEST"),
        AsyncGeneric("ASYNC_GENERIC"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ApiCallMode> map;

        private ApiCallMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ApiCallMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ApiCallMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ApiCallMode.class);
            map = new HashMap<String, ApiCallMode>();
            for (ApiCallMode v : ApiCallMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum MethodType implements BmcEnum
    {
        Get("GET"),
        Post("POST"),
        Patch("PATCH"),
        Delete("DELETE"),
        Put("PUT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, MethodType> map;

        private MethodType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MethodType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'MethodType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(MethodType.class);
            map = new HashMap<String, MethodType>();
            for (MethodType v : MethodType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="inputPorts")
        private List<InputPort> inputPorts;
        @JsonProperty(value="outputPorts")
        private List<OutputPort> outputPorts;
        @JsonProperty(value="parameters")
        private List<Parameter> parameters;
        @JsonProperty(value="opConfigValues")
        private ConfigValues opConfigValues;
        @JsonProperty(value="configProviderDelegate")
        private ConfigProvider configProviderDelegate;
        @JsonProperty(value="metadata")
        private ObjectMetadata metadata;
        @JsonProperty(value="keyMap")
        private Map<String, String> keyMap;
        @JsonProperty(value="authDetails")
        private AuthDetails authDetails;
        @JsonProperty(value="authConfig")
        private AuthConfig authConfig;
        @JsonProperty(value="endpoint")
        private Expression endpoint;
        @JsonProperty(value="methodType")
        private MethodType methodType;
        @JsonProperty(value="headers")
        private Object headers;
        @JsonProperty(value="jsonData")
        private String jsonData;
        @JsonProperty(value="apiCallMode")
        private ApiCallMode apiCallMode;
        @JsonProperty(value="cancelEndpoint")
        private Expression cancelEndpoint;
        @JsonProperty(value="cancelMethodType")
        private CancelMethodType cancelMethodType;
        @JsonProperty(value="executeRestCallConfig")
        private ExecuteRestCallConfig executeRestCallConfig;
        @JsonProperty(value="cancelRestCallConfig")
        private CancelRestCallConfig cancelRestCallConfig;
        @JsonProperty(value="pollRestCallConfig")
        private PollRestCallConfig pollRestCallConfig;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder inputPorts(List<InputPort> inputPorts) {
            this.inputPorts = inputPorts;
            this.__explicitlySet__.add("inputPorts");
            return this;
        }

        public Builder outputPorts(List<OutputPort> outputPorts) {
            this.outputPorts = outputPorts;
            this.__explicitlySet__.add("outputPorts");
            return this;
        }

        public Builder parameters(List<Parameter> parameters) {
            this.parameters = parameters;
            this.__explicitlySet__.add("parameters");
            return this;
        }

        public Builder opConfigValues(ConfigValues opConfigValues) {
            this.opConfigValues = opConfigValues;
            this.__explicitlySet__.add("opConfigValues");
            return this;
        }

        public Builder configProviderDelegate(ConfigProvider configProviderDelegate) {
            this.configProviderDelegate = configProviderDelegate;
            this.__explicitlySet__.add("configProviderDelegate");
            return this;
        }

        public Builder metadata(ObjectMetadata metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public Builder keyMap(Map<String, String> keyMap) {
            this.keyMap = keyMap;
            this.__explicitlySet__.add("keyMap");
            return this;
        }

        public Builder authDetails(AuthDetails authDetails) {
            this.authDetails = authDetails;
            this.__explicitlySet__.add("authDetails");
            return this;
        }

        public Builder authConfig(AuthConfig authConfig) {
            this.authConfig = authConfig;
            this.__explicitlySet__.add("authConfig");
            return this;
        }

        public Builder endpoint(Expression endpoint) {
            this.endpoint = endpoint;
            this.__explicitlySet__.add("endpoint");
            return this;
        }

        public Builder methodType(MethodType methodType) {
            this.methodType = methodType;
            this.__explicitlySet__.add("methodType");
            return this;
        }

        public Builder headers(Object headers) {
            this.headers = headers;
            this.__explicitlySet__.add("headers");
            return this;
        }

        public Builder jsonData(String jsonData) {
            this.jsonData = jsonData;
            this.__explicitlySet__.add("jsonData");
            return this;
        }

        public Builder apiCallMode(ApiCallMode apiCallMode) {
            this.apiCallMode = apiCallMode;
            this.__explicitlySet__.add("apiCallMode");
            return this;
        }

        public Builder cancelEndpoint(Expression cancelEndpoint) {
            this.cancelEndpoint = cancelEndpoint;
            this.__explicitlySet__.add("cancelEndpoint");
            return this;
        }

        public Builder cancelMethodType(CancelMethodType cancelMethodType) {
            this.cancelMethodType = cancelMethodType;
            this.__explicitlySet__.add("cancelMethodType");
            return this;
        }

        public Builder executeRestCallConfig(ExecuteRestCallConfig executeRestCallConfig) {
            this.executeRestCallConfig = executeRestCallConfig;
            this.__explicitlySet__.add("executeRestCallConfig");
            return this;
        }

        public Builder cancelRestCallConfig(CancelRestCallConfig cancelRestCallConfig) {
            this.cancelRestCallConfig = cancelRestCallConfig;
            this.__explicitlySet__.add("cancelRestCallConfig");
            return this;
        }

        public Builder pollRestCallConfig(PollRestCallConfig pollRestCallConfig) {
            this.pollRestCallConfig = pollRestCallConfig;
            this.__explicitlySet__.add("pollRestCallConfig");
            return this;
        }

        public TaskSummaryFromRestTask build() {
            TaskSummaryFromRestTask model = new TaskSummaryFromRestTask(this.key, this.modelVersion, this.parentRef, this.name, this.description, this.objectVersion, this.objectStatus, this.identifier, this.inputPorts, this.outputPorts, this.parameters, this.opConfigValues, this.configProviderDelegate, this.metadata, this.keyMap, this.authDetails, this.authConfig, this.endpoint, this.methodType, this.headers, this.jsonData, this.apiCallMode, this.cancelEndpoint, this.cancelMethodType, this.executeRestCallConfig, this.cancelRestCallConfig, this.pollRestCallConfig);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TaskSummaryFromRestTask model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("inputPorts")) {
                this.inputPorts(model.getInputPorts());
            }
            if (model.wasPropertyExplicitlySet("outputPorts")) {
                this.outputPorts(model.getOutputPorts());
            }
            if (model.wasPropertyExplicitlySet("parameters")) {
                this.parameters(model.getParameters());
            }
            if (model.wasPropertyExplicitlySet("opConfigValues")) {
                this.opConfigValues(model.getOpConfigValues());
            }
            if (model.wasPropertyExplicitlySet("configProviderDelegate")) {
                this.configProviderDelegate(model.getConfigProviderDelegate());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            if (model.wasPropertyExplicitlySet("keyMap")) {
                this.keyMap(model.getKeyMap());
            }
            if (model.wasPropertyExplicitlySet("authDetails")) {
                this.authDetails(model.getAuthDetails());
            }
            if (model.wasPropertyExplicitlySet("authConfig")) {
                this.authConfig(model.getAuthConfig());
            }
            if (model.wasPropertyExplicitlySet("endpoint")) {
                this.endpoint(model.getEndpoint());
            }
            if (model.wasPropertyExplicitlySet("methodType")) {
                this.methodType(model.getMethodType());
            }
            if (model.wasPropertyExplicitlySet("headers")) {
                this.headers(model.getHeaders());
            }
            if (model.wasPropertyExplicitlySet("jsonData")) {
                this.jsonData(model.getJsonData());
            }
            if (model.wasPropertyExplicitlySet("apiCallMode")) {
                this.apiCallMode(model.getApiCallMode());
            }
            if (model.wasPropertyExplicitlySet("cancelEndpoint")) {
                this.cancelEndpoint(model.getCancelEndpoint());
            }
            if (model.wasPropertyExplicitlySet("cancelMethodType")) {
                this.cancelMethodType(model.getCancelMethodType());
            }
            if (model.wasPropertyExplicitlySet("executeRestCallConfig")) {
                this.executeRestCallConfig(model.getExecuteRestCallConfig());
            }
            if (model.wasPropertyExplicitlySet("cancelRestCallConfig")) {
                this.cancelRestCallConfig(model.getCancelRestCallConfig());
            }
            if (model.wasPropertyExplicitlySet("pollRestCallConfig")) {
                this.pollRestCallConfig(model.getPollRestCallConfig());
            }
            return this;
        }
    }
}

