/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.CreateDataFlowDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateDataFlowRequest
extends BmcRequest<CreateDataFlowDetails> {
    private String workspaceId;
    private CreateDataFlowDetails createDataFlowDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public CreateDataFlowDetails getCreateDataFlowDetails() {
        return this.createDataFlowDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreateDataFlowDetails getBody$() {
        return this.createDataFlowDetails;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).createDataFlowDetails(this.createDataFlowDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",createDataFlowDetails=").append(String.valueOf((Object)this.createDataFlowDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDataFlowRequest)) {
            return false;
        }
        CreateDataFlowRequest other = (CreateDataFlowRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals((Object)this.createDataFlowDetails, (Object)other.createDataFlowDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.createDataFlowDetails == null ? 43 : this.createDataFlowDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateDataFlowRequest, CreateDataFlowDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private CreateDataFlowDetails createDataFlowDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder createDataFlowDetails(CreateDataFlowDetails createDataFlowDetails) {
            this.createDataFlowDetails = createDataFlowDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateDataFlowRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.createDataFlowDetails(o.getCreateDataFlowDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateDataFlowRequest build() {
            CreateDataFlowRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateDataFlowDetails body) {
            this.createDataFlowDetails(body);
            return this;
        }

        public CreateDataFlowRequest buildWithoutInvocationCallback() {
            CreateDataFlowRequest request = new CreateDataFlowRequest();
            request.workspaceId = this.workspaceId;
            request.createDataFlowDetails = this.createDataFlowDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

