/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RegistryMetadata
extends ExplicitlySetBmcModel {
    @JsonProperty(value="aggregatorKey")
    private final String aggregatorKey;
    @JsonProperty(value="labels")
    private final List<String> labels;
    @JsonProperty(value="registryVersion")
    private final Integer registryVersion;
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="isFavorite")
    private final Boolean isFavorite;

    @Deprecated
    @ConstructorProperties(value={"aggregatorKey", "labels", "registryVersion", "key", "isFavorite"})
    public RegistryMetadata(String aggregatorKey, List<String> labels, Integer registryVersion, String key, Boolean isFavorite) {
        this.aggregatorKey = aggregatorKey;
        this.labels = labels;
        this.registryVersion = registryVersion;
        this.key = key;
        this.isFavorite = isFavorite;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAggregatorKey() {
        return this.aggregatorKey;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public Integer getRegistryVersion() {
        return this.registryVersion;
    }

    public String getKey() {
        return this.key;
    }

    public Boolean getIsFavorite() {
        return this.isFavorite;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RegistryMetadata(");
        sb.append("super=").append(super.toString());
        sb.append("aggregatorKey=").append(String.valueOf(this.aggregatorKey));
        sb.append(", labels=").append(String.valueOf(this.labels));
        sb.append(", registryVersion=").append(String.valueOf(this.registryVersion));
        sb.append(", key=").append(String.valueOf(this.key));
        sb.append(", isFavorite=").append(String.valueOf(this.isFavorite));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegistryMetadata)) {
            return false;
        }
        RegistryMetadata other = (RegistryMetadata)((Object)o);
        return Objects.equals(this.aggregatorKey, other.aggregatorKey) && Objects.equals(this.labels, other.labels) && Objects.equals(this.registryVersion, other.registryVersion) && Objects.equals(this.key, other.key) && Objects.equals(this.isFavorite, other.isFavorite) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.aggregatorKey == null ? 43 : this.aggregatorKey.hashCode());
        result = result * 59 + (this.labels == null ? 43 : this.labels.hashCode());
        result = result * 59 + (this.registryVersion == null ? 43 : this.registryVersion.hashCode());
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.isFavorite == null ? 43 : this.isFavorite.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="aggregatorKey")
        private String aggregatorKey;
        @JsonProperty(value="labels")
        private List<String> labels;
        @JsonProperty(value="registryVersion")
        private Integer registryVersion;
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="isFavorite")
        private Boolean isFavorite;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder aggregatorKey(String aggregatorKey) {
            this.aggregatorKey = aggregatorKey;
            this.__explicitlySet__.add("aggregatorKey");
            return this;
        }

        public Builder labels(List<String> labels) {
            this.labels = labels;
            this.__explicitlySet__.add("labels");
            return this;
        }

        public Builder registryVersion(Integer registryVersion) {
            this.registryVersion = registryVersion;
            this.__explicitlySet__.add("registryVersion");
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder isFavorite(Boolean isFavorite) {
            this.isFavorite = isFavorite;
            this.__explicitlySet__.add("isFavorite");
            return this;
        }

        public RegistryMetadata build() {
            RegistryMetadata model = new RegistryMetadata(this.aggregatorKey, this.labels, this.registryVersion, this.key, this.isFavorite);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RegistryMetadata model) {
            if (model.wasPropertyExplicitlySet("aggregatorKey")) {
                this.aggregatorKey(model.getAggregatorKey());
            }
            if (model.wasPropertyExplicitlySet("labels")) {
                this.labels(model.getLabels());
            }
            if (model.wasPropertyExplicitlySet("registryVersion")) {
                this.registryVersion(model.getRegistryVersion());
            }
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("isFavorite")) {
                this.isFavorite(model.getIsFavorite());
            }
            return this;
        }
    }
}

