/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.CreateCopyObjectRequestDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateCopyObjectRequestRequest
extends BmcRequest<CreateCopyObjectRequestDetails> {
    private String workspaceId;
    private CreateCopyObjectRequestDetails createCopyObjectRequestDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public CreateCopyObjectRequestDetails getCreateCopyObjectRequestDetails() {
        return this.createCopyObjectRequestDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateCopyObjectRequestDetails getBody$() {
        return this.createCopyObjectRequestDetails;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).createCopyObjectRequestDetails(this.createCopyObjectRequestDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",createCopyObjectRequestDetails=").append(String.valueOf((Object)this.createCopyObjectRequestDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateCopyObjectRequestRequest)) {
            return false;
        }
        CreateCopyObjectRequestRequest other = (CreateCopyObjectRequestRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals((Object)this.createCopyObjectRequestDetails, (Object)other.createCopyObjectRequestDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.createCopyObjectRequestDetails == null ? 43 : this.createCopyObjectRequestDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateCopyObjectRequestRequest, CreateCopyObjectRequestDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private CreateCopyObjectRequestDetails createCopyObjectRequestDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder createCopyObjectRequestDetails(CreateCopyObjectRequestDetails createCopyObjectRequestDetails) {
            this.createCopyObjectRequestDetails = createCopyObjectRequestDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateCopyObjectRequestRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.createCopyObjectRequestDetails(o.getCreateCopyObjectRequestDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateCopyObjectRequestRequest build() {
            CreateCopyObjectRequestRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateCopyObjectRequestDetails body) {
            this.createCopyObjectRequestDetails(body);
            return this;
        }

        public CreateCopyObjectRequestRequest buildWithoutInvocationCallback() {
            CreateCopyObjectRequestRequest request = new CreateCopyObjectRequestRequest();
            request.workspaceId = this.workspaceId;
            request.createCopyObjectRequestDetails = this.createCopyObjectRequestDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

