/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteImportRequestRequest
extends BmcRequest<Void> {
    private String importRequestKey;
    private String workspaceId;
    private String opcRequestId;
    private String ifMatch;

    public String getImportRequestKey() {
        return this.importRequestKey;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().importRequestKey(this.importRequestKey).workspaceId(this.workspaceId).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",importRequestKey=").append(String.valueOf(this.importRequestKey));
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteImportRequestRequest)) {
            return false;
        }
        DeleteImportRequestRequest other = (DeleteImportRequestRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.importRequestKey, other.importRequestKey) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.importRequestKey == null ? 43 : this.importRequestKey.hashCode());
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteImportRequestRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String importRequestKey = null;
        private String workspaceId = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder importRequestKey(String importRequestKey) {
            this.importRequestKey = importRequestKey;
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteImportRequestRequest o) {
            this.importRequestKey(o.getImportRequestKey());
            this.workspaceId(o.getWorkspaceId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteImportRequestRequest build() {
            DeleteImportRequestRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteImportRequestRequest buildWithoutInvocationCallback() {
            DeleteImportRequestRequest request = new DeleteImportRequestRequest();
            request.importRequestKey = this.importRequestKey;
            request.workspaceId = this.workspaceId;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

