/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListImportRequestsRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String opcRequestId;
    private String page;
    private Integer limit;
    private String name;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private ImportStatus importStatus;
    private Projection projection;
    private Long timeStartedInMillis;
    private Long timeEndedInMillis;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getName() {
        return this.name;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public ImportStatus getImportStatus() {
        return this.importStatus;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public Long getTimeStartedInMillis() {
        return this.timeStartedInMillis;
    }

    public Long getTimeEndedInMillis() {
        return this.timeEndedInMillis;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).opcRequestId(this.opcRequestId).page(this.page).limit(this.limit).name(this.name).sortOrder(this.sortOrder).sortBy(this.sortBy).importStatus(this.importStatus).projection(this.projection).timeStartedInMillis(this.timeStartedInMillis).timeEndedInMillis(this.timeEndedInMillis);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",importStatus=").append(String.valueOf((Object)this.importStatus));
        sb.append(",projection=").append(String.valueOf((Object)this.projection));
        sb.append(",timeStartedInMillis=").append(String.valueOf(this.timeStartedInMillis));
        sb.append(",timeEndedInMillis=").append(String.valueOf(this.timeEndedInMillis));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListImportRequestsRequest)) {
            return false;
        }
        ListImportRequestsRequest other = (ListImportRequestsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.importStatus, (Object)other.importStatus) && Objects.equals((Object)this.projection, (Object)other.projection) && Objects.equals(this.timeStartedInMillis, other.timeStartedInMillis) && Objects.equals(this.timeEndedInMillis, other.timeEndedInMillis);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.importStatus == null ? 43 : this.importStatus.hashCode());
        result = result * 59 + (this.projection == null ? 43 : this.projection.hashCode());
        result = result * 59 + (this.timeStartedInMillis == null ? 43 : this.timeStartedInMillis.hashCode());
        result = result * 59 + (this.timeEndedInMillis == null ? 43 : this.timeEndedInMillis.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListImportRequestsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private String opcRequestId = null;
        private String page = null;
        private Integer limit = null;
        private String name = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private ImportStatus importStatus = null;
        private Projection projection = null;
        private Long timeStartedInMillis = null;
        private Long timeEndedInMillis = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder importStatus(ImportStatus importStatus) {
            this.importStatus = importStatus;
            return this;
        }

        public Builder projection(Projection projection) {
            this.projection = projection;
            return this;
        }

        public Builder timeStartedInMillis(Long timeStartedInMillis) {
            this.timeStartedInMillis = timeStartedInMillis;
            return this;
        }

        public Builder timeEndedInMillis(Long timeEndedInMillis) {
            this.timeEndedInMillis = timeEndedInMillis;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListImportRequestsRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.opcRequestId(o.getOpcRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.name(o.getName());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.importStatus(o.getImportStatus());
            this.projection(o.getProjection());
            this.timeStartedInMillis(o.getTimeStartedInMillis());
            this.timeEndedInMillis(o.getTimeEndedInMillis());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListImportRequestsRequest build() {
            ListImportRequestsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListImportRequestsRequest buildWithoutInvocationCallback() {
            ListImportRequestsRequest request = new ListImportRequestsRequest();
            request.workspaceId = this.workspaceId;
            request.opcRequestId = this.opcRequestId;
            request.page = this.page;
            request.limit = this.limit;
            request.name = this.name;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.importStatus = this.importStatus;
            request.projection = this.projection;
            request.timeStartedInMillis = this.timeStartedInMillis;
            request.timeEndedInMillis = this.timeEndedInMillis;
            return request;
        }
    }

    public static enum Projection implements BmcEnum
    {
        Summary("SUMMARY"),
        Details("DETAILS");

        private final String value;
        private static Map<String, Projection> map;

        private Projection(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Projection create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Projection: " + key);
        }

        static {
            map = new HashMap<String, Projection>();
            for (Projection v : Projection.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ImportStatus implements BmcEnum
    {
        InProgress("IN_PROGRESS"),
        Successful("SUCCESSFUL"),
        Queued("QUEUED"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Failed("FAILED");

        private final String value;
        private static Map<String, ImportStatus> map;

        private ImportStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ImportStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ImportStatus: " + key);
        }

        static {
            map = new HashMap<String, ImportStatus>();
            for (ImportStatus v : ImportStatus.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("TIME_CREATED"),
        DisplayName("DISPLAY_NAME"),
        TimeUpdated("TIME_UPDATED");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

