/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListRuntimeOperatorsRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String applicationKey;
    private String runtimePipelineKey;
    private String opcRequestId;
    private List<String> key;
    private List<String> fields;
    private String name;
    private List<String> identifier;
    private String page;
    private Integer limit;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private List<String> aggregatorType;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public String getRuntimePipelineKey() {
        return this.runtimePipelineKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<String> getKey() {
        return this.key;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getIdentifier() {
        return this.identifier;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public List<String> getAggregatorType() {
        return this.aggregatorType;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).applicationKey(this.applicationKey).runtimePipelineKey(this.runtimePipelineKey).opcRequestId(this.opcRequestId).key(this.key).fields(this.fields).name(this.name).identifier(this.identifier).page(this.page).limit(this.limit).sortOrder(this.sortOrder).sortBy(this.sortBy).aggregatorType(this.aggregatorType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",applicationKey=").append(String.valueOf(this.applicationKey));
        sb.append(",runtimePipelineKey=").append(String.valueOf(this.runtimePipelineKey));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",key=").append(String.valueOf(this.key));
        sb.append(",fields=").append(String.valueOf(this.fields));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",identifier=").append(String.valueOf(this.identifier));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",aggregatorType=").append(String.valueOf(this.aggregatorType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListRuntimeOperatorsRequest)) {
            return false;
        }
        ListRuntimeOperatorsRequest other = (ListRuntimeOperatorsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.applicationKey, other.applicationKey) && Objects.equals(this.runtimePipelineKey, other.runtimePipelineKey) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.key, other.key) && Objects.equals(this.fields, other.fields) && Objects.equals(this.name, other.name) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.aggregatorType, other.aggregatorType);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.applicationKey == null ? 43 : this.applicationKey.hashCode());
        result = result * 59 + (this.runtimePipelineKey == null ? 43 : this.runtimePipelineKey.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.aggregatorType == null ? 43 : this.aggregatorType.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListRuntimeOperatorsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private String applicationKey = null;
        private String runtimePipelineKey = null;
        private String opcRequestId = null;
        private List<String> key = null;
        private List<String> fields = null;
        private String name = null;
        private List<String> identifier = null;
        private String page = null;
        private Integer limit = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private List<String> aggregatorType = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            return this;
        }

        public Builder runtimePipelineKey(String runtimePipelineKey) {
            this.runtimePipelineKey = runtimePipelineKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder key(List<String> key) {
            this.key = key;
            return this;
        }

        public Builder key(String singularValue) {
            return this.key(Arrays.asList(singularValue));
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(String singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder identifier(List<String> identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder identifier(String singularValue) {
            return this.identifier(Arrays.asList(singularValue));
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder aggregatorType(List<String> aggregatorType) {
            this.aggregatorType = aggregatorType;
            return this;
        }

        public Builder aggregatorType(String singularValue) {
            return this.aggregatorType(Arrays.asList(singularValue));
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListRuntimeOperatorsRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.applicationKey(o.getApplicationKey());
            this.runtimePipelineKey(o.getRuntimePipelineKey());
            this.opcRequestId(o.getOpcRequestId());
            this.key(o.getKey());
            this.fields(o.getFields());
            this.name(o.getName());
            this.identifier(o.getIdentifier());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.aggregatorType(o.getAggregatorType());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListRuntimeOperatorsRequest build() {
            ListRuntimeOperatorsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListRuntimeOperatorsRequest buildWithoutInvocationCallback() {
            ListRuntimeOperatorsRequest request = new ListRuntimeOperatorsRequest();
            request.workspaceId = this.workspaceId;
            request.applicationKey = this.applicationKey;
            request.runtimePipelineKey = this.runtimePipelineKey;
            request.opcRequestId = this.opcRequestId;
            request.key = this.key;
            request.fields = this.fields;
            request.name = this.name;
            request.identifier = this.identifier;
            request.page = this.page;
            request.limit = this.limit;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.aggregatorType = this.aggregatorType;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("TIME_CREATED"),
        DisplayName("DISPLAY_NAME"),
        TimeUpdated("TIME_UPDATED");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

