/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateExportRequestDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="bucketName")
    private final String bucketName;
    @JsonProperty(value="fileName")
    private final String fileName;
    @JsonProperty(value="objectStorageTenancyId")
    private final String objectStorageTenancyId;
    @JsonProperty(value="objectStorageRegion")
    private final String objectStorageRegion;
    @JsonProperty(value="isObjectOverwriteEnabled")
    private final Boolean isObjectOverwriteEnabled;
    @JsonProperty(value="objectKeys")
    private final List<String> objectKeys;
    @JsonProperty(value="areReferencesIncluded")
    private final Boolean areReferencesIncluded;
    @JsonProperty(value="filters")
    private final List<String> filters;

    @Deprecated
    @ConstructorProperties(value={"bucketName", "fileName", "objectStorageTenancyId", "objectStorageRegion", "isObjectOverwriteEnabled", "objectKeys", "areReferencesIncluded", "filters"})
    public CreateExportRequestDetails(String bucketName, String fileName, String objectStorageTenancyId, String objectStorageRegion, Boolean isObjectOverwriteEnabled, List<String> objectKeys, Boolean areReferencesIncluded, List<String> filters) {
        this.bucketName = bucketName;
        this.fileName = fileName;
        this.objectStorageTenancyId = objectStorageTenancyId;
        this.objectStorageRegion = objectStorageRegion;
        this.isObjectOverwriteEnabled = isObjectOverwriteEnabled;
        this.objectKeys = objectKeys;
        this.areReferencesIncluded = areReferencesIncluded;
        this.filters = filters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getObjectStorageTenancyId() {
        return this.objectStorageTenancyId;
    }

    public String getObjectStorageRegion() {
        return this.objectStorageRegion;
    }

    public Boolean getIsObjectOverwriteEnabled() {
        return this.isObjectOverwriteEnabled;
    }

    public List<String> getObjectKeys() {
        return this.objectKeys;
    }

    public Boolean getAreReferencesIncluded() {
        return this.areReferencesIncluded;
    }

    public List<String> getFilters() {
        return this.filters;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateExportRequestDetails(");
        sb.append("super=").append(super.toString());
        sb.append("bucketName=").append(String.valueOf(this.bucketName));
        sb.append(", fileName=").append(String.valueOf(this.fileName));
        sb.append(", objectStorageTenancyId=").append(String.valueOf(this.objectStorageTenancyId));
        sb.append(", objectStorageRegion=").append(String.valueOf(this.objectStorageRegion));
        sb.append(", isObjectOverwriteEnabled=").append(String.valueOf(this.isObjectOverwriteEnabled));
        sb.append(", objectKeys=").append(String.valueOf(this.objectKeys));
        sb.append(", areReferencesIncluded=").append(String.valueOf(this.areReferencesIncluded));
        sb.append(", filters=").append(String.valueOf(this.filters));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateExportRequestDetails)) {
            return false;
        }
        CreateExportRequestDetails other = (CreateExportRequestDetails)((Object)o);
        return Objects.equals(this.bucketName, other.bucketName) && Objects.equals(this.fileName, other.fileName) && Objects.equals(this.objectStorageTenancyId, other.objectStorageTenancyId) && Objects.equals(this.objectStorageRegion, other.objectStorageRegion) && Objects.equals(this.isObjectOverwriteEnabled, other.isObjectOverwriteEnabled) && Objects.equals(this.objectKeys, other.objectKeys) && Objects.equals(this.areReferencesIncluded, other.areReferencesIncluded) && Objects.equals(this.filters, other.filters) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.bucketName == null ? 43 : this.bucketName.hashCode());
        result = result * 59 + (this.fileName == null ? 43 : this.fileName.hashCode());
        result = result * 59 + (this.objectStorageTenancyId == null ? 43 : this.objectStorageTenancyId.hashCode());
        result = result * 59 + (this.objectStorageRegion == null ? 43 : this.objectStorageRegion.hashCode());
        result = result * 59 + (this.isObjectOverwriteEnabled == null ? 43 : this.isObjectOverwriteEnabled.hashCode());
        result = result * 59 + (this.objectKeys == null ? 43 : this.objectKeys.hashCode());
        result = result * 59 + (this.areReferencesIncluded == null ? 43 : this.areReferencesIncluded.hashCode());
        result = result * 59 + (this.filters == null ? 43 : this.filters.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="bucketName")
        private String bucketName;
        @JsonProperty(value="fileName")
        private String fileName;
        @JsonProperty(value="objectStorageTenancyId")
        private String objectStorageTenancyId;
        @JsonProperty(value="objectStorageRegion")
        private String objectStorageRegion;
        @JsonProperty(value="isObjectOverwriteEnabled")
        private Boolean isObjectOverwriteEnabled;
        @JsonProperty(value="objectKeys")
        private List<String> objectKeys;
        @JsonProperty(value="areReferencesIncluded")
        private Boolean areReferencesIncluded;
        @JsonProperty(value="filters")
        private List<String> filters;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            this.__explicitlySet__.add("bucketName");
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.__explicitlySet__.add("fileName");
            return this;
        }

        public Builder objectStorageTenancyId(String objectStorageTenancyId) {
            this.objectStorageTenancyId = objectStorageTenancyId;
            this.__explicitlySet__.add("objectStorageTenancyId");
            return this;
        }

        public Builder objectStorageRegion(String objectStorageRegion) {
            this.objectStorageRegion = objectStorageRegion;
            this.__explicitlySet__.add("objectStorageRegion");
            return this;
        }

        public Builder isObjectOverwriteEnabled(Boolean isObjectOverwriteEnabled) {
            this.isObjectOverwriteEnabled = isObjectOverwriteEnabled;
            this.__explicitlySet__.add("isObjectOverwriteEnabled");
            return this;
        }

        public Builder objectKeys(List<String> objectKeys) {
            this.objectKeys = objectKeys;
            this.__explicitlySet__.add("objectKeys");
            return this;
        }

        public Builder areReferencesIncluded(Boolean areReferencesIncluded) {
            this.areReferencesIncluded = areReferencesIncluded;
            this.__explicitlySet__.add("areReferencesIncluded");
            return this;
        }

        public Builder filters(List<String> filters) {
            this.filters = filters;
            this.__explicitlySet__.add("filters");
            return this;
        }

        public CreateExportRequestDetails build() {
            CreateExportRequestDetails model = new CreateExportRequestDetails(this.bucketName, this.fileName, this.objectStorageTenancyId, this.objectStorageRegion, this.isObjectOverwriteEnabled, this.objectKeys, this.areReferencesIncluded, this.filters);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateExportRequestDetails model) {
            if (model.wasPropertyExplicitlySet("bucketName")) {
                this.bucketName(model.getBucketName());
            }
            if (model.wasPropertyExplicitlySet("fileName")) {
                this.fileName(model.getFileName());
            }
            if (model.wasPropertyExplicitlySet("objectStorageTenancyId")) {
                this.objectStorageTenancyId(model.getObjectStorageTenancyId());
            }
            if (model.wasPropertyExplicitlySet("objectStorageRegion")) {
                this.objectStorageRegion(model.getObjectStorageRegion());
            }
            if (model.wasPropertyExplicitlySet("isObjectOverwriteEnabled")) {
                this.isObjectOverwriteEnabled(model.getIsObjectOverwriteEnabled());
            }
            if (model.wasPropertyExplicitlySet("objectKeys")) {
                this.objectKeys(model.getObjectKeys());
            }
            if (model.wasPropertyExplicitlySet("areReferencesIncluded")) {
                this.areReferencesIncluded(model.getAreReferencesIncluded());
            }
            if (model.wasPropertyExplicitlySet("filters")) {
                this.filters(model.getFilters());
            }
            return this;
        }
    }
}

