/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ImportConflictResolution;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateImportRequestDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="bucketName")
    private final String bucketName;
    @JsonProperty(value="fileName")
    private final String fileName;
    @JsonProperty(value="objectStorageTenancyId")
    private final String objectStorageTenancyId;
    @JsonProperty(value="objectStorageRegion")
    private final String objectStorageRegion;
    @JsonProperty(value="objectKeyForImport")
    private final String objectKeyForImport;
    @JsonProperty(value="importConflictResolution")
    private final ImportConflictResolution importConflictResolution;

    @Deprecated
    @ConstructorProperties(value={"bucketName", "fileName", "objectStorageTenancyId", "objectStorageRegion", "objectKeyForImport", "importConflictResolution"})
    public CreateImportRequestDetails(String bucketName, String fileName, String objectStorageTenancyId, String objectStorageRegion, String objectKeyForImport, ImportConflictResolution importConflictResolution) {
        this.bucketName = bucketName;
        this.fileName = fileName;
        this.objectStorageTenancyId = objectStorageTenancyId;
        this.objectStorageRegion = objectStorageRegion;
        this.objectKeyForImport = objectKeyForImport;
        this.importConflictResolution = importConflictResolution;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getObjectStorageTenancyId() {
        return this.objectStorageTenancyId;
    }

    public String getObjectStorageRegion() {
        return this.objectStorageRegion;
    }

    public String getObjectKeyForImport() {
        return this.objectKeyForImport;
    }

    public ImportConflictResolution getImportConflictResolution() {
        return this.importConflictResolution;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateImportRequestDetails(");
        sb.append("super=").append(super.toString());
        sb.append("bucketName=").append(String.valueOf(this.bucketName));
        sb.append(", fileName=").append(String.valueOf(this.fileName));
        sb.append(", objectStorageTenancyId=").append(String.valueOf(this.objectStorageTenancyId));
        sb.append(", objectStorageRegion=").append(String.valueOf(this.objectStorageRegion));
        sb.append(", objectKeyForImport=").append(String.valueOf(this.objectKeyForImport));
        sb.append(", importConflictResolution=").append(String.valueOf((Object)this.importConflictResolution));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateImportRequestDetails)) {
            return false;
        }
        CreateImportRequestDetails other = (CreateImportRequestDetails)((Object)o);
        return Objects.equals(this.bucketName, other.bucketName) && Objects.equals(this.fileName, other.fileName) && Objects.equals(this.objectStorageTenancyId, other.objectStorageTenancyId) && Objects.equals(this.objectStorageRegion, other.objectStorageRegion) && Objects.equals(this.objectKeyForImport, other.objectKeyForImport) && Objects.equals((Object)this.importConflictResolution, (Object)other.importConflictResolution) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.bucketName == null ? 43 : this.bucketName.hashCode());
        result = result * 59 + (this.fileName == null ? 43 : this.fileName.hashCode());
        result = result * 59 + (this.objectStorageTenancyId == null ? 43 : this.objectStorageTenancyId.hashCode());
        result = result * 59 + (this.objectStorageRegion == null ? 43 : this.objectStorageRegion.hashCode());
        result = result * 59 + (this.objectKeyForImport == null ? 43 : this.objectKeyForImport.hashCode());
        result = result * 59 + (this.importConflictResolution == null ? 43 : this.importConflictResolution.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="bucketName")
        private String bucketName;
        @JsonProperty(value="fileName")
        private String fileName;
        @JsonProperty(value="objectStorageTenancyId")
        private String objectStorageTenancyId;
        @JsonProperty(value="objectStorageRegion")
        private String objectStorageRegion;
        @JsonProperty(value="objectKeyForImport")
        private String objectKeyForImport;
        @JsonProperty(value="importConflictResolution")
        private ImportConflictResolution importConflictResolution;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            this.__explicitlySet__.add("bucketName");
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.__explicitlySet__.add("fileName");
            return this;
        }

        public Builder objectStorageTenancyId(String objectStorageTenancyId) {
            this.objectStorageTenancyId = objectStorageTenancyId;
            this.__explicitlySet__.add("objectStorageTenancyId");
            return this;
        }

        public Builder objectStorageRegion(String objectStorageRegion) {
            this.objectStorageRegion = objectStorageRegion;
            this.__explicitlySet__.add("objectStorageRegion");
            return this;
        }

        public Builder objectKeyForImport(String objectKeyForImport) {
            this.objectKeyForImport = objectKeyForImport;
            this.__explicitlySet__.add("objectKeyForImport");
            return this;
        }

        public Builder importConflictResolution(ImportConflictResolution importConflictResolution) {
            this.importConflictResolution = importConflictResolution;
            this.__explicitlySet__.add("importConflictResolution");
            return this;
        }

        public CreateImportRequestDetails build() {
            CreateImportRequestDetails model = new CreateImportRequestDetails(this.bucketName, this.fileName, this.objectStorageTenancyId, this.objectStorageRegion, this.objectKeyForImport, this.importConflictResolution);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateImportRequestDetails model) {
            if (model.wasPropertyExplicitlySet("bucketName")) {
                this.bucketName(model.getBucketName());
            }
            if (model.wasPropertyExplicitlySet("fileName")) {
                this.fileName(model.getFileName());
            }
            if (model.wasPropertyExplicitlySet("objectStorageTenancyId")) {
                this.objectStorageTenancyId(model.getObjectStorageTenancyId());
            }
            if (model.wasPropertyExplicitlySet("objectStorageRegion")) {
                this.objectStorageRegion(model.getObjectStorageRegion());
            }
            if (model.wasPropertyExplicitlySet("objectKeyForImport")) {
                this.objectKeyForImport(model.getObjectKeyForImport());
            }
            if (model.wasPropertyExplicitlySet("importConflictResolution")) {
                this.importConflictResolution(model.getImportConflictResolution());
            }
            return this;
        }
    }
}

