/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.FieldMap;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.ScopeReference;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class DirectNamedFieldMap
extends FieldMap {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="configValues")
    private final ConfigValues configValues;
    @JsonProperty(value="sourceTypedObject")
    private final String sourceTypedObject;
    @JsonProperty(value="targetTypedObject")
    private final String targetTypedObject;
    @JsonProperty(value="sourceScopeReference")
    private final ScopeReference sourceScopeReference;
    @JsonProperty(value="targetScopeReference")
    private final ScopeReference targetScopeReference;
    @JsonProperty(value="sourceFieldName")
    private final String sourceFieldName;
    @JsonProperty(value="targetFieldName")
    private final String targetFieldName;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DirectNamedFieldMap(String description, String key, String modelVersion, ParentReference parentRef, ConfigValues configValues, String sourceTypedObject, String targetTypedObject, ScopeReference sourceScopeReference, ScopeReference targetScopeReference, String sourceFieldName, String targetFieldName, Integer objectStatus) {
        super(description);
        this.key = key;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.configValues = configValues;
        this.sourceTypedObject = sourceTypedObject;
        this.targetTypedObject = targetTypedObject;
        this.sourceScopeReference = sourceScopeReference;
        this.targetScopeReference = targetScopeReference;
        this.sourceFieldName = sourceFieldName;
        this.targetFieldName = targetFieldName;
        this.objectStatus = objectStatus;
    }

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public ConfigValues getConfigValues() {
        return this.configValues;
    }

    public String getSourceTypedObject() {
        return this.sourceTypedObject;
    }

    public String getTargetTypedObject() {
        return this.targetTypedObject;
    }

    public ScopeReference getSourceScopeReference() {
        return this.sourceScopeReference;
    }

    public ScopeReference getTargetScopeReference() {
        return this.targetScopeReference;
    }

    public String getSourceFieldName() {
        return this.sourceFieldName;
    }

    public String getTargetFieldName() {
        return this.targetFieldName;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DirectNamedFieldMap(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", key=").append(String.valueOf(this.key));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", configValues=").append(String.valueOf((Object)this.configValues));
        sb.append(", sourceTypedObject=").append(String.valueOf(this.sourceTypedObject));
        sb.append(", targetTypedObject=").append(String.valueOf(this.targetTypedObject));
        sb.append(", sourceScopeReference=").append(String.valueOf((Object)this.sourceScopeReference));
        sb.append(", targetScopeReference=").append(String.valueOf((Object)this.targetScopeReference));
        sb.append(", sourceFieldName=").append(String.valueOf(this.sourceFieldName));
        sb.append(", targetFieldName=").append(String.valueOf(this.targetFieldName));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DirectNamedFieldMap)) {
            return false;
        }
        DirectNamedFieldMap other = (DirectNamedFieldMap)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals((Object)this.configValues, (Object)other.configValues) && Objects.equals(this.sourceTypedObject, other.sourceTypedObject) && Objects.equals(this.targetTypedObject, other.targetTypedObject) && Objects.equals((Object)this.sourceScopeReference, (Object)other.sourceScopeReference) && Objects.equals((Object)this.targetScopeReference, (Object)other.targetScopeReference) && Objects.equals(this.sourceFieldName, other.sourceFieldName) && Objects.equals(this.targetFieldName, other.targetFieldName) && Objects.equals(this.objectStatus, other.objectStatus) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.configValues == null ? 43 : this.configValues.hashCode());
        result = result * 59 + (this.sourceTypedObject == null ? 43 : this.sourceTypedObject.hashCode());
        result = result * 59 + (this.targetTypedObject == null ? 43 : this.targetTypedObject.hashCode());
        result = result * 59 + (this.sourceScopeReference == null ? 43 : this.sourceScopeReference.hashCode());
        result = result * 59 + (this.targetScopeReference == null ? 43 : this.targetScopeReference.hashCode());
        result = result * 59 + (this.sourceFieldName == null ? 43 : this.sourceFieldName.hashCode());
        result = result * 59 + (this.targetFieldName == null ? 43 : this.targetFieldName.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="configValues")
        private ConfigValues configValues;
        @JsonProperty(value="sourceTypedObject")
        private String sourceTypedObject;
        @JsonProperty(value="targetTypedObject")
        private String targetTypedObject;
        @JsonProperty(value="sourceScopeReference")
        private ScopeReference sourceScopeReference;
        @JsonProperty(value="targetScopeReference")
        private ScopeReference targetScopeReference;
        @JsonProperty(value="sourceFieldName")
        private String sourceFieldName;
        @JsonProperty(value="targetFieldName")
        private String targetFieldName;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder configValues(ConfigValues configValues) {
            this.configValues = configValues;
            this.__explicitlySet__.add("configValues");
            return this;
        }

        public Builder sourceTypedObject(String sourceTypedObject) {
            this.sourceTypedObject = sourceTypedObject;
            this.__explicitlySet__.add("sourceTypedObject");
            return this;
        }

        public Builder targetTypedObject(String targetTypedObject) {
            this.targetTypedObject = targetTypedObject;
            this.__explicitlySet__.add("targetTypedObject");
            return this;
        }

        public Builder sourceScopeReference(ScopeReference sourceScopeReference) {
            this.sourceScopeReference = sourceScopeReference;
            this.__explicitlySet__.add("sourceScopeReference");
            return this;
        }

        public Builder targetScopeReference(ScopeReference targetScopeReference) {
            this.targetScopeReference = targetScopeReference;
            this.__explicitlySet__.add("targetScopeReference");
            return this;
        }

        public Builder sourceFieldName(String sourceFieldName) {
            this.sourceFieldName = sourceFieldName;
            this.__explicitlySet__.add("sourceFieldName");
            return this;
        }

        public Builder targetFieldName(String targetFieldName) {
            this.targetFieldName = targetFieldName;
            this.__explicitlySet__.add("targetFieldName");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public DirectNamedFieldMap build() {
            DirectNamedFieldMap model = new DirectNamedFieldMap(this.description, this.key, this.modelVersion, this.parentRef, this.configValues, this.sourceTypedObject, this.targetTypedObject, this.sourceScopeReference, this.targetScopeReference, this.sourceFieldName, this.targetFieldName, this.objectStatus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DirectNamedFieldMap model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("configValues")) {
                this.configValues(model.getConfigValues());
            }
            if (model.wasPropertyExplicitlySet("sourceTypedObject")) {
                this.sourceTypedObject(model.getSourceTypedObject());
            }
            if (model.wasPropertyExplicitlySet("targetTypedObject")) {
                this.targetTypedObject(model.getTargetTypedObject());
            }
            if (model.wasPropertyExplicitlySet("sourceScopeReference")) {
                this.sourceScopeReference(model.getSourceScopeReference());
            }
            if (model.wasPropertyExplicitlySet("targetScopeReference")) {
                this.targetScopeReference(model.getTargetScopeReference());
            }
            if (model.wasPropertyExplicitlySet("sourceFieldName")) {
                this.sourceFieldName(model.getSourceFieldName());
            }
            if (model.wasPropertyExplicitlySet("targetFieldName")) {
                this.targetFieldName(model.getTargetFieldName());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            return this;
        }
    }
}

