/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class IncrementalFieldClause
extends ExplicitlySetBmcModel {
    @JsonProperty(value="incrementalFieldName")
    private final String incrementalFieldName;
    @JsonProperty(value="incrementalFieldValue")
    private final Map<String, String> incrementalFieldValue;
    @JsonProperty(value="incrementalComparator")
    private final IncrementalComparator incrementalComparator;

    @Deprecated
    @ConstructorProperties(value={"incrementalFieldName", "incrementalFieldValue", "incrementalComparator"})
    public IncrementalFieldClause(String incrementalFieldName, Map<String, String> incrementalFieldValue, IncrementalComparator incrementalComparator) {
        this.incrementalFieldName = incrementalFieldName;
        this.incrementalFieldValue = incrementalFieldValue;
        this.incrementalComparator = incrementalComparator;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getIncrementalFieldName() {
        return this.incrementalFieldName;
    }

    public Map<String, String> getIncrementalFieldValue() {
        return this.incrementalFieldValue;
    }

    public IncrementalComparator getIncrementalComparator() {
        return this.incrementalComparator;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("IncrementalFieldClause(");
        sb.append("super=").append(super.toString());
        sb.append("incrementalFieldName=").append(String.valueOf(this.incrementalFieldName));
        sb.append(", incrementalFieldValue=").append(String.valueOf(this.incrementalFieldValue));
        sb.append(", incrementalComparator=").append(String.valueOf((Object)this.incrementalComparator));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IncrementalFieldClause)) {
            return false;
        }
        IncrementalFieldClause other = (IncrementalFieldClause)((Object)o);
        return Objects.equals(this.incrementalFieldName, other.incrementalFieldName) && Objects.equals(this.incrementalFieldValue, other.incrementalFieldValue) && Objects.equals((Object)this.incrementalComparator, (Object)other.incrementalComparator) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.incrementalFieldName == null ? 43 : this.incrementalFieldName.hashCode());
        result = result * 59 + (this.incrementalFieldValue == null ? 43 : this.incrementalFieldValue.hashCode());
        result = result * 59 + (this.incrementalComparator == null ? 43 : this.incrementalComparator.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum IncrementalComparator implements BmcEnum
    {
        Lessthan("LESSTHAN"),
        Greaterthan("GREATERTHAN"),
        Equals("EQUALS"),
        Lessthanequals("LESSTHANEQUALS"),
        Greaterthanequals("GREATERTHANEQUALS"),
        Startswith("STARTSWITH"),
        Contains("CONTAINS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, IncrementalComparator> map;

        private IncrementalComparator(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IncrementalComparator create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'IncrementalComparator', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(IncrementalComparator.class);
            map = new HashMap<String, IncrementalComparator>();
            for (IncrementalComparator v : IncrementalComparator.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="incrementalFieldName")
        private String incrementalFieldName;
        @JsonProperty(value="incrementalFieldValue")
        private Map<String, String> incrementalFieldValue;
        @JsonProperty(value="incrementalComparator")
        private IncrementalComparator incrementalComparator;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder incrementalFieldName(String incrementalFieldName) {
            this.incrementalFieldName = incrementalFieldName;
            this.__explicitlySet__.add("incrementalFieldName");
            return this;
        }

        public Builder incrementalFieldValue(Map<String, String> incrementalFieldValue) {
            this.incrementalFieldValue = incrementalFieldValue;
            this.__explicitlySet__.add("incrementalFieldValue");
            return this;
        }

        public Builder incrementalComparator(IncrementalComparator incrementalComparator) {
            this.incrementalComparator = incrementalComparator;
            this.__explicitlySet__.add("incrementalComparator");
            return this;
        }

        public IncrementalFieldClause build() {
            IncrementalFieldClause model = new IncrementalFieldClause(this.incrementalFieldName, this.incrementalFieldValue, this.incrementalComparator);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(IncrementalFieldClause model) {
            if (model.wasPropertyExplicitlySet("incrementalFieldName")) {
                this.incrementalFieldName(model.getIncrementalFieldName());
            }
            if (model.wasPropertyExplicitlySet("incrementalFieldValue")) {
                this.incrementalFieldValue(model.getIncrementalFieldValue());
            }
            if (model.wasPropertyExplicitlySet("incrementalComparator")) {
                this.incrementalComparator(model.getIncrementalComparator());
            }
            return this;
        }
    }
}

