/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.IncrementalDataEntityClause;
import com.oracle.bmc.dataintegration.model.IncrementalFieldClause;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class IncrementalReadConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="lastExtractedFieldDate")
    private final List<IncrementalFieldClause> lastExtractedFieldDate;
    @JsonProperty(value="lastExtractedDataEntityDate")
    private final List<IncrementalDataEntityClause> lastExtractedDataEntityDate;

    @Deprecated
    @ConstructorProperties(value={"lastExtractedFieldDate", "lastExtractedDataEntityDate"})
    public IncrementalReadConfig(List<IncrementalFieldClause> lastExtractedFieldDate, List<IncrementalDataEntityClause> lastExtractedDataEntityDate) {
        this.lastExtractedFieldDate = lastExtractedFieldDate;
        this.lastExtractedDataEntityDate = lastExtractedDataEntityDate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<IncrementalFieldClause> getLastExtractedFieldDate() {
        return this.lastExtractedFieldDate;
    }

    public List<IncrementalDataEntityClause> getLastExtractedDataEntityDate() {
        return this.lastExtractedDataEntityDate;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("IncrementalReadConfig(");
        sb.append("super=").append(super.toString());
        sb.append("lastExtractedFieldDate=").append(String.valueOf(this.lastExtractedFieldDate));
        sb.append(", lastExtractedDataEntityDate=").append(String.valueOf(this.lastExtractedDataEntityDate));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IncrementalReadConfig)) {
            return false;
        }
        IncrementalReadConfig other = (IncrementalReadConfig)((Object)o);
        return Objects.equals(this.lastExtractedFieldDate, other.lastExtractedFieldDate) && Objects.equals(this.lastExtractedDataEntityDate, other.lastExtractedDataEntityDate) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.lastExtractedFieldDate == null ? 43 : this.lastExtractedFieldDate.hashCode());
        result = result * 59 + (this.lastExtractedDataEntityDate == null ? 43 : this.lastExtractedDataEntityDate.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="lastExtractedFieldDate")
        private List<IncrementalFieldClause> lastExtractedFieldDate;
        @JsonProperty(value="lastExtractedDataEntityDate")
        private List<IncrementalDataEntityClause> lastExtractedDataEntityDate;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder lastExtractedFieldDate(List<IncrementalFieldClause> lastExtractedFieldDate) {
            this.lastExtractedFieldDate = lastExtractedFieldDate;
            this.__explicitlySet__.add("lastExtractedFieldDate");
            return this;
        }

        public Builder lastExtractedDataEntityDate(List<IncrementalDataEntityClause> lastExtractedDataEntityDate) {
            this.lastExtractedDataEntityDate = lastExtractedDataEntityDate;
            this.__explicitlySet__.add("lastExtractedDataEntityDate");
            return this;
        }

        public IncrementalReadConfig build() {
            IncrementalReadConfig model = new IncrementalReadConfig(this.lastExtractedFieldDate, this.lastExtractedDataEntityDate);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(IncrementalReadConfig model) {
            if (model.wasPropertyExplicitlySet("lastExtractedFieldDate")) {
                this.lastExtractedFieldDate(model.getLastExtractedFieldDate());
            }
            if (model.wasPropertyExplicitlySet("lastExtractedDataEntityDate")) {
                this.lastExtractedDataEntityDate(model.getLastExtractedDataEntityDate());
            }
            return this;
        }
    }
}

