/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ObjectMetadata;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.PatchObjectMetadata;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Patch
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelType")
    private final String modelType;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="objectVersion")
    private final Integer objectVersion;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="timePatched")
    private final Date timePatched;
    @JsonProperty(value="errorMessages")
    private final Map<String, String> errorMessages;
    @JsonProperty(value="applicationVersion")
    private final Integer applicationVersion;
    @JsonProperty(value="patchType")
    private final PatchType patchType;
    @JsonProperty(value="patchStatus")
    private final PatchStatus patchStatus;
    @JsonProperty(value="dependentObjectMetadata")
    private final List<PatchObjectMetadata> dependentObjectMetadata;
    @JsonProperty(value="patchObjectMetadata")
    private final List<PatchObjectMetadata> patchObjectMetadata;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="metadata")
    private final ObjectMetadata metadata;
    @JsonProperty(value="keyMap")
    private final Map<String, String> keyMap;

    @Deprecated
    @ConstructorProperties(value={"key", "modelType", "modelVersion", "name", "description", "objectVersion", "objectStatus", "identifier", "timePatched", "errorMessages", "applicationVersion", "patchType", "patchStatus", "dependentObjectMetadata", "patchObjectMetadata", "parentRef", "metadata", "keyMap"})
    public Patch(String key, String modelType, String modelVersion, String name, String description, Integer objectVersion, Integer objectStatus, String identifier, Date timePatched, Map<String, String> errorMessages, Integer applicationVersion, PatchType patchType, PatchStatus patchStatus, List<PatchObjectMetadata> dependentObjectMetadata, List<PatchObjectMetadata> patchObjectMetadata, ParentReference parentRef, ObjectMetadata metadata, Map<String, String> keyMap) {
        this.key = key;
        this.modelType = modelType;
        this.modelVersion = modelVersion;
        this.name = name;
        this.description = description;
        this.objectVersion = objectVersion;
        this.objectStatus = objectStatus;
        this.identifier = identifier;
        this.timePatched = timePatched;
        this.errorMessages = errorMessages;
        this.applicationVersion = applicationVersion;
        this.patchType = patchType;
        this.patchStatus = patchStatus;
        this.dependentObjectMetadata = dependentObjectMetadata;
        this.patchObjectMetadata = patchObjectMetadata;
        this.parentRef = parentRef;
        this.metadata = metadata;
        this.keyMap = keyMap;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Date getTimePatched() {
        return this.timePatched;
    }

    public Map<String, String> getErrorMessages() {
        return this.errorMessages;
    }

    public Integer getApplicationVersion() {
        return this.applicationVersion;
    }

    public PatchType getPatchType() {
        return this.patchType;
    }

    public PatchStatus getPatchStatus() {
        return this.patchStatus;
    }

    public List<PatchObjectMetadata> getDependentObjectMetadata() {
        return this.dependentObjectMetadata;
    }

    public List<PatchObjectMetadata> getPatchObjectMetadata() {
        return this.patchObjectMetadata;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public Map<String, String> getKeyMap() {
        return this.keyMap;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Patch(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", modelType=").append(String.valueOf(this.modelType));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", objectVersion=").append(String.valueOf(this.objectVersion));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(", identifier=").append(String.valueOf(this.identifier));
        sb.append(", timePatched=").append(String.valueOf(this.timePatched));
        sb.append(", errorMessages=").append(String.valueOf(this.errorMessages));
        sb.append(", applicationVersion=").append(String.valueOf(this.applicationVersion));
        sb.append(", patchType=").append(String.valueOf((Object)this.patchType));
        sb.append(", patchStatus=").append(String.valueOf((Object)this.patchStatus));
        sb.append(", dependentObjectMetadata=").append(String.valueOf(this.dependentObjectMetadata));
        sb.append(", patchObjectMetadata=").append(String.valueOf(this.patchObjectMetadata));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", metadata=").append(String.valueOf((Object)this.metadata));
        sb.append(", keyMap=").append(String.valueOf(this.keyMap));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Patch)) {
            return false;
        }
        Patch other = (Patch)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelType, other.modelType) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.objectVersion, other.objectVersion) && Objects.equals(this.objectStatus, other.objectStatus) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.timePatched, other.timePatched) && Objects.equals(this.errorMessages, other.errorMessages) && Objects.equals(this.applicationVersion, other.applicationVersion) && Objects.equals((Object)this.patchType, (Object)other.patchType) && Objects.equals((Object)this.patchStatus, (Object)other.patchStatus) && Objects.equals(this.dependentObjectMetadata, other.dependentObjectMetadata) && Objects.equals(this.patchObjectMetadata, other.patchObjectMetadata) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals((Object)this.metadata, (Object)other.metadata) && Objects.equals(this.keyMap, other.keyMap) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelType == null ? 43 : this.modelType.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.objectVersion == null ? 43 : this.objectVersion.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.timePatched == null ? 43 : this.timePatched.hashCode());
        result = result * 59 + (this.errorMessages == null ? 43 : this.errorMessages.hashCode());
        result = result * 59 + (this.applicationVersion == null ? 43 : this.applicationVersion.hashCode());
        result = result * 59 + (this.patchType == null ? 43 : this.patchType.hashCode());
        result = result * 59 + (this.patchStatus == null ? 43 : this.patchStatus.hashCode());
        result = result * 59 + (this.dependentObjectMetadata == null ? 43 : this.dependentObjectMetadata.hashCode());
        result = result * 59 + (this.patchObjectMetadata == null ? 43 : this.patchObjectMetadata.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + (this.keyMap == null ? 43 : this.keyMap.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum PatchStatus implements BmcEnum
    {
        Queued("QUEUED"),
        Successful("SUCCESSFUL"),
        Failed("FAILED"),
        InProgress("IN_PROGRESS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PatchStatus> map;

        private PatchStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PatchStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PatchStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PatchStatus.class);
            map = new HashMap<String, PatchStatus>();
            for (PatchStatus v : PatchStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PatchType implements BmcEnum
    {
        Publish("PUBLISH"),
        Refresh("REFRESH"),
        Unpublish("UNPUBLISH"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PatchType> map;

        private PatchType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PatchType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PatchType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PatchType.class);
            map = new HashMap<String, PatchType>();
            for (PatchType v : PatchType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelType")
        private String modelType;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="timePatched")
        private Date timePatched;
        @JsonProperty(value="errorMessages")
        private Map<String, String> errorMessages;
        @JsonProperty(value="applicationVersion")
        private Integer applicationVersion;
        @JsonProperty(value="patchType")
        private PatchType patchType;
        @JsonProperty(value="patchStatus")
        private PatchStatus patchStatus;
        @JsonProperty(value="dependentObjectMetadata")
        private List<PatchObjectMetadata> dependentObjectMetadata;
        @JsonProperty(value="patchObjectMetadata")
        private List<PatchObjectMetadata> patchObjectMetadata;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="metadata")
        private ObjectMetadata metadata;
        @JsonProperty(value="keyMap")
        private Map<String, String> keyMap;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelType(String modelType) {
            this.modelType = modelType;
            this.__explicitlySet__.add("modelType");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder timePatched(Date timePatched) {
            this.timePatched = timePatched;
            this.__explicitlySet__.add("timePatched");
            return this;
        }

        public Builder errorMessages(Map<String, String> errorMessages) {
            this.errorMessages = errorMessages;
            this.__explicitlySet__.add("errorMessages");
            return this;
        }

        public Builder applicationVersion(Integer applicationVersion) {
            this.applicationVersion = applicationVersion;
            this.__explicitlySet__.add("applicationVersion");
            return this;
        }

        public Builder patchType(PatchType patchType) {
            this.patchType = patchType;
            this.__explicitlySet__.add("patchType");
            return this;
        }

        public Builder patchStatus(PatchStatus patchStatus) {
            this.patchStatus = patchStatus;
            this.__explicitlySet__.add("patchStatus");
            return this;
        }

        public Builder dependentObjectMetadata(List<PatchObjectMetadata> dependentObjectMetadata) {
            this.dependentObjectMetadata = dependentObjectMetadata;
            this.__explicitlySet__.add("dependentObjectMetadata");
            return this;
        }

        public Builder patchObjectMetadata(List<PatchObjectMetadata> patchObjectMetadata) {
            this.patchObjectMetadata = patchObjectMetadata;
            this.__explicitlySet__.add("patchObjectMetadata");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder metadata(ObjectMetadata metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public Builder keyMap(Map<String, String> keyMap) {
            this.keyMap = keyMap;
            this.__explicitlySet__.add("keyMap");
            return this;
        }

        public Patch build() {
            Patch model = new Patch(this.key, this.modelType, this.modelVersion, this.name, this.description, this.objectVersion, this.objectStatus, this.identifier, this.timePatched, this.errorMessages, this.applicationVersion, this.patchType, this.patchStatus, this.dependentObjectMetadata, this.patchObjectMetadata, this.parentRef, this.metadata, this.keyMap);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Patch model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelType")) {
                this.modelType(model.getModelType());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("timePatched")) {
                this.timePatched(model.getTimePatched());
            }
            if (model.wasPropertyExplicitlySet("errorMessages")) {
                this.errorMessages(model.getErrorMessages());
            }
            if (model.wasPropertyExplicitlySet("applicationVersion")) {
                this.applicationVersion(model.getApplicationVersion());
            }
            if (model.wasPropertyExplicitlySet("patchType")) {
                this.patchType(model.getPatchType());
            }
            if (model.wasPropertyExplicitlySet("patchStatus")) {
                this.patchStatus(model.getPatchStatus());
            }
            if (model.wasPropertyExplicitlySet("dependentObjectMetadata")) {
                this.dependentObjectMetadata(model.getDependentObjectMetadata());
            }
            if (model.wasPropertyExplicitlySet("patchObjectMetadata")) {
                this.patchObjectMetadata(model.getPatchObjectMetadata());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            if (model.wasPropertyExplicitlySet("keyMap")) {
                this.keyMap(model.getKeyMap());
            }
            return this;
        }
    }
}

