/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigProvider;
import com.oracle.bmc.dataintegration.model.ObjectMetadata;
import com.oracle.bmc.dataintegration.model.Operator;
import com.oracle.bmc.dataintegration.model.Parameter;
import com.oracle.bmc.dataintegration.model.ParameterValue;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RuntimeOperator
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="taskRunKey")
    private final String taskRunKey;
    @JsonProperty(value="startTimeInMillis")
    private final Long startTimeInMillis;
    @JsonProperty(value="endTimeInMillis")
    private final Long endTimeInMillis;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="modelType")
    private final String modelType;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="objectVersion")
    private final Integer objectVersion;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="executionState")
    private final ExecutionState executionState;
    @JsonProperty(value="parameters")
    private final List<Parameter> parameters;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="metadata")
    private final ObjectMetadata metadata;
    @JsonProperty(value="operator")
    private final Operator operator;
    @JsonProperty(value="inputs")
    private final Map<String, ParameterValue> inputs;
    @JsonProperty(value="outputs")
    private final Map<String, ParameterValue> outputs;
    @JsonProperty(value="taskType")
    private final TaskType taskType;
    @JsonProperty(value="configProvider")
    private final ConfigProvider configProvider;
    @JsonProperty(value="operatorType")
    private final OperatorType operatorType;
    @JsonProperty(value="metrics")
    private final Map<String, Float> metrics;

    @Deprecated
    @ConstructorProperties(value={"key", "taskRunKey", "startTimeInMillis", "endTimeInMillis", "status", "modelType", "modelVersion", "parentRef", "name", "objectVersion", "identifier", "executionState", "parameters", "objectStatus", "metadata", "operator", "inputs", "outputs", "taskType", "configProvider", "operatorType", "metrics"})
    public RuntimeOperator(String key, String taskRunKey, Long startTimeInMillis, Long endTimeInMillis, Status status, String modelType, String modelVersion, ParentReference parentRef, String name, Integer objectVersion, String identifier, ExecutionState executionState, List<Parameter> parameters, Integer objectStatus, ObjectMetadata metadata, Operator operator, Map<String, ParameterValue> inputs, Map<String, ParameterValue> outputs, TaskType taskType, ConfigProvider configProvider, OperatorType operatorType, Map<String, Float> metrics) {
        this.key = key;
        this.taskRunKey = taskRunKey;
        this.startTimeInMillis = startTimeInMillis;
        this.endTimeInMillis = endTimeInMillis;
        this.status = status;
        this.modelType = modelType;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.name = name;
        this.objectVersion = objectVersion;
        this.identifier = identifier;
        this.executionState = executionState;
        this.parameters = parameters;
        this.objectStatus = objectStatus;
        this.metadata = metadata;
        this.operator = operator;
        this.inputs = inputs;
        this.outputs = outputs;
        this.taskType = taskType;
        this.configProvider = configProvider;
        this.operatorType = operatorType;
        this.metrics = metrics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getTaskRunKey() {
        return this.taskRunKey;
    }

    public Long getStartTimeInMillis() {
        return this.startTimeInMillis;
    }

    public Long getEndTimeInMillis() {
        return this.endTimeInMillis;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getName() {
        return this.name;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Map<String, ParameterValue> getInputs() {
        return this.inputs;
    }

    public Map<String, ParameterValue> getOutputs() {
        return this.outputs;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public ConfigProvider getConfigProvider() {
        return this.configProvider;
    }

    public OperatorType getOperatorType() {
        return this.operatorType;
    }

    public Map<String, Float> getMetrics() {
        return this.metrics;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RuntimeOperator(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", taskRunKey=").append(String.valueOf(this.taskRunKey));
        sb.append(", startTimeInMillis=").append(String.valueOf(this.startTimeInMillis));
        sb.append(", endTimeInMillis=").append(String.valueOf(this.endTimeInMillis));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", modelType=").append(String.valueOf(this.modelType));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", objectVersion=").append(String.valueOf(this.objectVersion));
        sb.append(", identifier=").append(String.valueOf(this.identifier));
        sb.append(", executionState=").append(String.valueOf((Object)this.executionState));
        sb.append(", parameters=").append(String.valueOf(this.parameters));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(", metadata=").append(String.valueOf((Object)this.metadata));
        sb.append(", operator=").append(String.valueOf((Object)this.operator));
        sb.append(", inputs=").append(String.valueOf(this.inputs));
        sb.append(", outputs=").append(String.valueOf(this.outputs));
        sb.append(", taskType=").append(String.valueOf((Object)this.taskType));
        sb.append(", configProvider=").append(String.valueOf((Object)this.configProvider));
        sb.append(", operatorType=").append(String.valueOf((Object)this.operatorType));
        sb.append(", metrics=").append(String.valueOf(this.metrics));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RuntimeOperator)) {
            return false;
        }
        RuntimeOperator other = (RuntimeOperator)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.taskRunKey, other.taskRunKey) && Objects.equals(this.startTimeInMillis, other.startTimeInMillis) && Objects.equals(this.endTimeInMillis, other.endTimeInMillis) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.modelType, other.modelType) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals(this.name, other.name) && Objects.equals(this.objectVersion, other.objectVersion) && Objects.equals(this.identifier, other.identifier) && Objects.equals((Object)this.executionState, (Object)other.executionState) && Objects.equals(this.parameters, other.parameters) && Objects.equals(this.objectStatus, other.objectStatus) && Objects.equals((Object)this.metadata, (Object)other.metadata) && Objects.equals((Object)this.operator, (Object)other.operator) && Objects.equals(this.inputs, other.inputs) && Objects.equals(this.outputs, other.outputs) && Objects.equals((Object)this.taskType, (Object)other.taskType) && Objects.equals((Object)this.configProvider, (Object)other.configProvider) && Objects.equals((Object)this.operatorType, (Object)other.operatorType) && Objects.equals(this.metrics, other.metrics) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.taskRunKey == null ? 43 : this.taskRunKey.hashCode());
        result = result * 59 + (this.startTimeInMillis == null ? 43 : this.startTimeInMillis.hashCode());
        result = result * 59 + (this.endTimeInMillis == null ? 43 : this.endTimeInMillis.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.modelType == null ? 43 : this.modelType.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.objectVersion == null ? 43 : this.objectVersion.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.executionState == null ? 43 : this.executionState.hashCode());
        result = result * 59 + (this.parameters == null ? 43 : this.parameters.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + (this.operator == null ? 43 : this.operator.hashCode());
        result = result * 59 + (this.inputs == null ? 43 : this.inputs.hashCode());
        result = result * 59 + (this.outputs == null ? 43 : this.outputs.hashCode());
        result = result * 59 + (this.taskType == null ? 43 : this.taskType.hashCode());
        result = result * 59 + (this.configProvider == null ? 43 : this.configProvider.hashCode());
        result = result * 59 + (this.operatorType == null ? 43 : this.operatorType.hashCode());
        result = result * 59 + (this.metrics == null ? 43 : this.metrics.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum OperatorType implements BmcEnum
    {
        BashOperator("BASH_OPERATOR"),
        TaskOperator("TASK_OPERATOR"),
        RestOperator("REST_OPERATOR"),
        StartOperator("START_OPERATOR"),
        EndOperator("END_OPERATOR"),
        ExpressionOperator("EXPRESSION_OPERATOR"),
        MergeOperator("MERGE_OPERATOR"),
        DecisionOperator("DECISION_OPERATOR"),
        LoopOperator("LOOP_OPERATOR"),
        ActualEndOperator("ACTUAL_END_OPERATOR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OperatorType> map;

        private OperatorType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OperatorType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OperatorType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OperatorType.class);
            map = new HashMap<String, OperatorType>();
            for (OperatorType v : OperatorType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum TaskType implements BmcEnum
    {
        IntegrationTask("INTEGRATION_TASK"),
        DataLoaderTask("DATA_LOADER_TASK"),
        PipelineTask("PIPELINE_TASK"),
        SqlTask("SQL_TASK"),
        OciDataflowTask("OCI_DATAFLOW_TASK"),
        RestTask("REST_TASK"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TaskType> map;

        private TaskType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TaskType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TaskType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TaskType.class);
            map = new HashMap<String, TaskType>();
            for (TaskType v : TaskType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ExecutionState implements BmcEnum
    {
        NotStarted("NOT_STARTED"),
        Running("RUNNING"),
        Terminated("TERMINATED"),
        Success("SUCCESS"),
        Error("ERROR"),
        Skipped("SKIPPED"),
        Unknown("UNKNOWN"),
        Ignored("IGNORED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ExecutionState> map;

        private ExecutionState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ExecutionState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ExecutionState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ExecutionState.class);
            map = new HashMap<String, ExecutionState>();
            for (ExecutionState v : ExecutionState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status implements BmcEnum
    {
        NotStarted("NOT_STARTED"),
        Queued("QUEUED"),
        Running("RUNNING"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Success("SUCCESS"),
        Error("ERROR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="taskRunKey")
        private String taskRunKey;
        @JsonProperty(value="startTimeInMillis")
        private Long startTimeInMillis;
        @JsonProperty(value="endTimeInMillis")
        private Long endTimeInMillis;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="modelType")
        private String modelType;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="executionState")
        private ExecutionState executionState;
        @JsonProperty(value="parameters")
        private List<Parameter> parameters;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="metadata")
        private ObjectMetadata metadata;
        @JsonProperty(value="operator")
        private Operator operator;
        @JsonProperty(value="inputs")
        private Map<String, ParameterValue> inputs;
        @JsonProperty(value="outputs")
        private Map<String, ParameterValue> outputs;
        @JsonProperty(value="taskType")
        private TaskType taskType;
        @JsonProperty(value="configProvider")
        private ConfigProvider configProvider;
        @JsonProperty(value="operatorType")
        private OperatorType operatorType;
        @JsonProperty(value="metrics")
        private Map<String, Float> metrics;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder taskRunKey(String taskRunKey) {
            this.taskRunKey = taskRunKey;
            this.__explicitlySet__.add("taskRunKey");
            return this;
        }

        public Builder startTimeInMillis(Long startTimeInMillis) {
            this.startTimeInMillis = startTimeInMillis;
            this.__explicitlySet__.add("startTimeInMillis");
            return this;
        }

        public Builder endTimeInMillis(Long endTimeInMillis) {
            this.endTimeInMillis = endTimeInMillis;
            this.__explicitlySet__.add("endTimeInMillis");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder modelType(String modelType) {
            this.modelType = modelType;
            this.__explicitlySet__.add("modelType");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder executionState(ExecutionState executionState) {
            this.executionState = executionState;
            this.__explicitlySet__.add("executionState");
            return this;
        }

        public Builder parameters(List<Parameter> parameters) {
            this.parameters = parameters;
            this.__explicitlySet__.add("parameters");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder metadata(ObjectMetadata metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public Builder operator(Operator operator) {
            this.operator = operator;
            this.__explicitlySet__.add("operator");
            return this;
        }

        public Builder inputs(Map<String, ParameterValue> inputs) {
            this.inputs = inputs;
            this.__explicitlySet__.add("inputs");
            return this;
        }

        public Builder outputs(Map<String, ParameterValue> outputs) {
            this.outputs = outputs;
            this.__explicitlySet__.add("outputs");
            return this;
        }

        public Builder taskType(TaskType taskType) {
            this.taskType = taskType;
            this.__explicitlySet__.add("taskType");
            return this;
        }

        public Builder configProvider(ConfigProvider configProvider) {
            this.configProvider = configProvider;
            this.__explicitlySet__.add("configProvider");
            return this;
        }

        public Builder operatorType(OperatorType operatorType) {
            this.operatorType = operatorType;
            this.__explicitlySet__.add("operatorType");
            return this;
        }

        public Builder metrics(Map<String, Float> metrics) {
            this.metrics = metrics;
            this.__explicitlySet__.add("metrics");
            return this;
        }

        public RuntimeOperator build() {
            RuntimeOperator model = new RuntimeOperator(this.key, this.taskRunKey, this.startTimeInMillis, this.endTimeInMillis, this.status, this.modelType, this.modelVersion, this.parentRef, this.name, this.objectVersion, this.identifier, this.executionState, this.parameters, this.objectStatus, this.metadata, this.operator, this.inputs, this.outputs, this.taskType, this.configProvider, this.operatorType, this.metrics);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RuntimeOperator model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("taskRunKey")) {
                this.taskRunKey(model.getTaskRunKey());
            }
            if (model.wasPropertyExplicitlySet("startTimeInMillis")) {
                this.startTimeInMillis(model.getStartTimeInMillis());
            }
            if (model.wasPropertyExplicitlySet("endTimeInMillis")) {
                this.endTimeInMillis(model.getEndTimeInMillis());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("modelType")) {
                this.modelType(model.getModelType());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("executionState")) {
                this.executionState(model.getExecutionState());
            }
            if (model.wasPropertyExplicitlySet("parameters")) {
                this.parameters(model.getParameters());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            if (model.wasPropertyExplicitlySet("operator")) {
                this.operator(model.getOperator());
            }
            if (model.wasPropertyExplicitlySet("inputs")) {
                this.inputs(model.getInputs());
            }
            if (model.wasPropertyExplicitlySet("outputs")) {
                this.outputs(model.getOutputs());
            }
            if (model.wasPropertyExplicitlySet("taskType")) {
                this.taskType(model.getTaskType());
            }
            if (model.wasPropertyExplicitlySet("configProvider")) {
                this.configProvider(model.getConfigProvider());
            }
            if (model.wasPropertyExplicitlySet("operatorType")) {
                this.operatorType(model.getOperatorType());
            }
            if (model.wasPropertyExplicitlySet("metrics")) {
                this.metrics(model.getMetrics());
            }
            return this;
        }
    }
}

