/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ParameterValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class State
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="parameterValue")
    private final ParameterValue parameterValue;
    @JsonProperty(value="timeValue")
    private final Date timeValue;

    @Deprecated
    @ConstructorProperties(value={"name", "parameterValue", "timeValue"})
    public State(String name, ParameterValue parameterValue, Date timeValue) {
        this.name = name;
        this.parameterValue = parameterValue;
        this.timeValue = timeValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public ParameterValue getParameterValue() {
        return this.parameterValue;
    }

    public Date getTimeValue() {
        return this.timeValue;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("State(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", parameterValue=").append(String.valueOf((Object)this.parameterValue));
        sb.append(", timeValue=").append(String.valueOf(this.timeValue));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof State)) {
            return false;
        }
        State other = (State)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.parameterValue, (Object)other.parameterValue) && Objects.equals(this.timeValue, other.timeValue) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.parameterValue == null ? 43 : this.parameterValue.hashCode());
        result = result * 59 + (this.timeValue == null ? 43 : this.timeValue.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="parameterValue")
        private ParameterValue parameterValue;
        @JsonProperty(value="timeValue")
        private Date timeValue;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder parameterValue(ParameterValue parameterValue) {
            this.parameterValue = parameterValue;
            this.__explicitlySet__.add("parameterValue");
            return this;
        }

        public Builder timeValue(Date timeValue) {
            this.timeValue = timeValue;
            this.__explicitlySet__.add("timeValue");
            return this;
        }

        public State build() {
            State model = new State(this.name, this.parameterValue, this.timeValue);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(State model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("parameterValue")) {
                this.parameterValue(model.getParameterValue());
            }
            if (model.wasPropertyExplicitlySet("timeValue")) {
                this.timeValue(model.getTimeValue());
            }
            return this;
        }
    }
}

