/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.DataFlow;
import com.oracle.bmc.dataintegration.model.ObjectMetadata;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TaskRunLineageSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelType")
    private final String modelType;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="objectVersion")
    private final Integer objectVersion;
    @JsonProperty(value="taskName")
    private final String taskName;
    @JsonProperty(value="taskType")
    private final String taskType;
    @JsonProperty(value="taskKey")
    private final String taskKey;
    @JsonProperty(value="isLineageGenCompleted")
    private final Boolean isLineageGenCompleted;
    @JsonProperty(value="taskExecutionStatus")
    private final TaskExecutionStatus taskExecutionStatus;
    @JsonProperty(value="flow")
    private final DataFlow flow;
    @JsonProperty(value="metadata")
    private final ObjectMetadata metadata;

    @Deprecated
    @ConstructorProperties(value={"key", "modelType", "modelVersion", "parentRef", "name", "description", "objectVersion", "taskName", "taskType", "taskKey", "isLineageGenCompleted", "taskExecutionStatus", "flow", "metadata"})
    public TaskRunLineageSummary(String key, String modelType, String modelVersion, ParentReference parentRef, String name, String description, Integer objectVersion, String taskName, String taskType, String taskKey, Boolean isLineageGenCompleted, TaskExecutionStatus taskExecutionStatus, DataFlow flow, ObjectMetadata metadata) {
        this.key = key;
        this.modelType = modelType;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.name = name;
        this.description = description;
        this.objectVersion = objectVersion;
        this.taskName = taskName;
        this.taskType = taskType;
        this.taskKey = taskKey;
        this.isLineageGenCompleted = isLineageGenCompleted;
        this.taskExecutionStatus = taskExecutionStatus;
        this.flow = flow;
        this.metadata = metadata;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public String getTaskKey() {
        return this.taskKey;
    }

    public Boolean getIsLineageGenCompleted() {
        return this.isLineageGenCompleted;
    }

    public TaskExecutionStatus getTaskExecutionStatus() {
        return this.taskExecutionStatus;
    }

    public DataFlow getFlow() {
        return this.flow;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TaskRunLineageSummary(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", modelType=").append(String.valueOf(this.modelType));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", objectVersion=").append(String.valueOf(this.objectVersion));
        sb.append(", taskName=").append(String.valueOf(this.taskName));
        sb.append(", taskType=").append(String.valueOf(this.taskType));
        sb.append(", taskKey=").append(String.valueOf(this.taskKey));
        sb.append(", isLineageGenCompleted=").append(String.valueOf(this.isLineageGenCompleted));
        sb.append(", taskExecutionStatus=").append(String.valueOf((Object)this.taskExecutionStatus));
        sb.append(", flow=").append(String.valueOf((Object)this.flow));
        sb.append(", metadata=").append(String.valueOf((Object)this.metadata));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskRunLineageSummary)) {
            return false;
        }
        TaskRunLineageSummary other = (TaskRunLineageSummary)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelType, other.modelType) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.objectVersion, other.objectVersion) && Objects.equals(this.taskName, other.taskName) && Objects.equals(this.taskType, other.taskType) && Objects.equals(this.taskKey, other.taskKey) && Objects.equals(this.isLineageGenCompleted, other.isLineageGenCompleted) && Objects.equals((Object)this.taskExecutionStatus, (Object)other.taskExecutionStatus) && Objects.equals((Object)this.flow, (Object)other.flow) && Objects.equals((Object)this.metadata, (Object)other.metadata) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelType == null ? 43 : this.modelType.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.objectVersion == null ? 43 : this.objectVersion.hashCode());
        result = result * 59 + (this.taskName == null ? 43 : this.taskName.hashCode());
        result = result * 59 + (this.taskType == null ? 43 : this.taskType.hashCode());
        result = result * 59 + (this.taskKey == null ? 43 : this.taskKey.hashCode());
        result = result * 59 + (this.isLineageGenCompleted == null ? 43 : this.isLineageGenCompleted.hashCode());
        result = result * 59 + (this.taskExecutionStatus == null ? 43 : this.taskExecutionStatus.hashCode());
        result = result * 59 + (this.flow == null ? 43 : this.flow.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum TaskExecutionStatus implements BmcEnum
    {
        Success("SUCCESS"),
        Error("ERROR"),
        Terminated("TERMINATED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TaskExecutionStatus> map;

        private TaskExecutionStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TaskExecutionStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TaskExecutionStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TaskExecutionStatus.class);
            map = new HashMap<String, TaskExecutionStatus>();
            for (TaskExecutionStatus v : TaskExecutionStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelType")
        private String modelType;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="taskName")
        private String taskName;
        @JsonProperty(value="taskType")
        private String taskType;
        @JsonProperty(value="taskKey")
        private String taskKey;
        @JsonProperty(value="isLineageGenCompleted")
        private Boolean isLineageGenCompleted;
        @JsonProperty(value="taskExecutionStatus")
        private TaskExecutionStatus taskExecutionStatus;
        @JsonProperty(value="flow")
        private DataFlow flow;
        @JsonProperty(value="metadata")
        private ObjectMetadata metadata;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelType(String modelType) {
            this.modelType = modelType;
            this.__explicitlySet__.add("modelType");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder taskName(String taskName) {
            this.taskName = taskName;
            this.__explicitlySet__.add("taskName");
            return this;
        }

        public Builder taskType(String taskType) {
            this.taskType = taskType;
            this.__explicitlySet__.add("taskType");
            return this;
        }

        public Builder taskKey(String taskKey) {
            this.taskKey = taskKey;
            this.__explicitlySet__.add("taskKey");
            return this;
        }

        public Builder isLineageGenCompleted(Boolean isLineageGenCompleted) {
            this.isLineageGenCompleted = isLineageGenCompleted;
            this.__explicitlySet__.add("isLineageGenCompleted");
            return this;
        }

        public Builder taskExecutionStatus(TaskExecutionStatus taskExecutionStatus) {
            this.taskExecutionStatus = taskExecutionStatus;
            this.__explicitlySet__.add("taskExecutionStatus");
            return this;
        }

        public Builder flow(DataFlow flow) {
            this.flow = flow;
            this.__explicitlySet__.add("flow");
            return this;
        }

        public Builder metadata(ObjectMetadata metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public TaskRunLineageSummary build() {
            TaskRunLineageSummary model = new TaskRunLineageSummary(this.key, this.modelType, this.modelVersion, this.parentRef, this.name, this.description, this.objectVersion, this.taskName, this.taskType, this.taskKey, this.isLineageGenCompleted, this.taskExecutionStatus, this.flow, this.metadata);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TaskRunLineageSummary model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelType")) {
                this.modelType(model.getModelType());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("taskName")) {
                this.taskName(model.getTaskName());
            }
            if (model.wasPropertyExplicitlySet("taskType")) {
                this.taskType(model.getTaskType());
            }
            if (model.wasPropertyExplicitlySet("taskKey")) {
                this.taskKey(model.getTaskKey());
            }
            if (model.wasPropertyExplicitlySet("isLineageGenCompleted")) {
                this.isLineageGenCompleted(model.getIsLineageGenCompleted());
            }
            if (model.wasPropertyExplicitlySet("taskExecutionStatus")) {
                this.taskExecutionStatus(model.getTaskExecutionStatus());
            }
            if (model.wasPropertyExplicitlySet("flow")) {
                this.flow(model.getFlow());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            return this;
        }
    }
}

