/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ValidationMessage
extends ExplicitlySetBmcModel {
    @JsonProperty(value="level")
    private final String level;
    @JsonProperty(value="messageKey")
    private final String messageKey;
    @JsonProperty(value="validationMessage")
    private final String validationMessage;

    @Deprecated
    @ConstructorProperties(value={"level", "messageKey", "validationMessage"})
    public ValidationMessage(String level, String messageKey, String validationMessage) {
        this.level = level;
        this.messageKey = messageKey;
        this.validationMessage = validationMessage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getLevel() {
        return this.level;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public String getValidationMessage() {
        return this.validationMessage;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ValidationMessage(");
        sb.append("super=").append(super.toString());
        sb.append("level=").append(String.valueOf(this.level));
        sb.append(", messageKey=").append(String.valueOf(this.messageKey));
        sb.append(", validationMessage=").append(String.valueOf(this.validationMessage));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValidationMessage)) {
            return false;
        }
        ValidationMessage other = (ValidationMessage)((Object)o);
        return Objects.equals(this.level, other.level) && Objects.equals(this.messageKey, other.messageKey) && Objects.equals(this.validationMessage, other.validationMessage) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.level == null ? 43 : this.level.hashCode());
        result = result * 59 + (this.messageKey == null ? 43 : this.messageKey.hashCode());
        result = result * 59 + (this.validationMessage == null ? 43 : this.validationMessage.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="level")
        private String level;
        @JsonProperty(value="messageKey")
        private String messageKey;
        @JsonProperty(value="validationMessage")
        private String validationMessage;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder level(String level) {
            this.level = level;
            this.__explicitlySet__.add("level");
            return this;
        }

        public Builder messageKey(String messageKey) {
            this.messageKey = messageKey;
            this.__explicitlySet__.add("messageKey");
            return this;
        }

        public Builder validationMessage(String validationMessage) {
            this.validationMessage = validationMessage;
            this.__explicitlySet__.add("validationMessage");
            return this;
        }

        public ValidationMessage build() {
            ValidationMessage model = new ValidationMessage(this.level, this.messageKey, this.validationMessage);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ValidationMessage model) {
            if (model.wasPropertyExplicitlySet("level")) {
                this.level(model.getLevel());
            }
            if (model.wasPropertyExplicitlySet("messageKey")) {
                this.messageKey(model.getMessageKey());
            }
            if (model.wasPropertyExplicitlySet("validationMessage")) {
                this.validationMessage(model.getValidationMessage());
            }
            return this;
        }
    }
}

