/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.UpdateExportRequestDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateExportRequestRequest
extends BmcRequest<UpdateExportRequestDetails> {
    private String workspaceId;
    private String exportRequestKey;
    private UpdateExportRequestDetails updateExportRequestDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getExportRequestKey() {
        return this.exportRequestKey;
    }

    public UpdateExportRequestDetails getUpdateExportRequestDetails() {
        return this.updateExportRequestDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateExportRequestDetails getBody$() {
        return this.updateExportRequestDetails;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).exportRequestKey(this.exportRequestKey).updateExportRequestDetails(this.updateExportRequestDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",exportRequestKey=").append(String.valueOf(this.exportRequestKey));
        sb.append(",updateExportRequestDetails=").append(String.valueOf((Object)this.updateExportRequestDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateExportRequestRequest)) {
            return false;
        }
        UpdateExportRequestRequest other = (UpdateExportRequestRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.exportRequestKey, other.exportRequestKey) && Objects.equals((Object)this.updateExportRequestDetails, (Object)other.updateExportRequestDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.exportRequestKey == null ? 43 : this.exportRequestKey.hashCode());
        result = result * 59 + (this.updateExportRequestDetails == null ? 43 : this.updateExportRequestDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateExportRequestRequest, UpdateExportRequestDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private String exportRequestKey = null;
        private UpdateExportRequestDetails updateExportRequestDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder exportRequestKey(String exportRequestKey) {
            this.exportRequestKey = exportRequestKey;
            return this;
        }

        public Builder updateExportRequestDetails(UpdateExportRequestDetails updateExportRequestDetails) {
            this.updateExportRequestDetails = updateExportRequestDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateExportRequestRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.exportRequestKey(o.getExportRequestKey());
            this.updateExportRequestDetails(o.getUpdateExportRequestDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateExportRequestRequest build() {
            UpdateExportRequestRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateExportRequestDetails body) {
            this.updateExportRequestDetails(body);
            return this;
        }

        public UpdateExportRequestRequest buildWithoutInvocationCallback() {
            UpdateExportRequestRequest request = new UpdateExportRequestRequest();
            request.workspaceId = this.workspaceId;
            request.exportRequestKey = this.exportRequestKey;
            request.updateExportRequestDetails = this.updateExportRequestDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

