/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExportObjectMetadataSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="objectType")
    private final String objectType;
    @JsonProperty(value="objectVersion")
    private final String objectVersion;
    @JsonProperty(value="aggregatorKey")
    private final String aggregatorKey;
    @JsonProperty(value="namePath")
    private final String namePath;
    @JsonProperty(value="timeUpdatedInMillis")
    private final Long timeUpdatedInMillis;

    @Deprecated
    @ConstructorProperties(value={"key", "name", "identifier", "objectType", "objectVersion", "aggregatorKey", "namePath", "timeUpdatedInMillis"})
    public ExportObjectMetadataSummary(String key, String name, String identifier, String objectType, String objectVersion, String aggregatorKey, String namePath, Long timeUpdatedInMillis) {
        this.key = key;
        this.name = name;
        this.identifier = identifier;
        this.objectType = objectType;
        this.objectVersion = objectVersion;
        this.aggregatorKey = aggregatorKey;
        this.namePath = namePath;
        this.timeUpdatedInMillis = timeUpdatedInMillis;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getObjectVersion() {
        return this.objectVersion;
    }

    public String getAggregatorKey() {
        return this.aggregatorKey;
    }

    public String getNamePath() {
        return this.namePath;
    }

    public Long getTimeUpdatedInMillis() {
        return this.timeUpdatedInMillis;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExportObjectMetadataSummary(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", identifier=").append(String.valueOf(this.identifier));
        sb.append(", objectType=").append(String.valueOf(this.objectType));
        sb.append(", objectVersion=").append(String.valueOf(this.objectVersion));
        sb.append(", aggregatorKey=").append(String.valueOf(this.aggregatorKey));
        sb.append(", namePath=").append(String.valueOf(this.namePath));
        sb.append(", timeUpdatedInMillis=").append(String.valueOf(this.timeUpdatedInMillis));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExportObjectMetadataSummary)) {
            return false;
        }
        ExportObjectMetadataSummary other = (ExportObjectMetadataSummary)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.name, other.name) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.objectType, other.objectType) && Objects.equals(this.objectVersion, other.objectVersion) && Objects.equals(this.aggregatorKey, other.aggregatorKey) && Objects.equals(this.namePath, other.namePath) && Objects.equals(this.timeUpdatedInMillis, other.timeUpdatedInMillis) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.objectType == null ? 43 : this.objectType.hashCode());
        result = result * 59 + (this.objectVersion == null ? 43 : this.objectVersion.hashCode());
        result = result * 59 + (this.aggregatorKey == null ? 43 : this.aggregatorKey.hashCode());
        result = result * 59 + (this.namePath == null ? 43 : this.namePath.hashCode());
        result = result * 59 + (this.timeUpdatedInMillis == null ? 43 : this.timeUpdatedInMillis.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="objectType")
        private String objectType;
        @JsonProperty(value="objectVersion")
        private String objectVersion;
        @JsonProperty(value="aggregatorKey")
        private String aggregatorKey;
        @JsonProperty(value="namePath")
        private String namePath;
        @JsonProperty(value="timeUpdatedInMillis")
        private Long timeUpdatedInMillis;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder objectType(String objectType) {
            this.objectType = objectType;
            this.__explicitlySet__.add("objectType");
            return this;
        }

        public Builder objectVersion(String objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder aggregatorKey(String aggregatorKey) {
            this.aggregatorKey = aggregatorKey;
            this.__explicitlySet__.add("aggregatorKey");
            return this;
        }

        public Builder namePath(String namePath) {
            this.namePath = namePath;
            this.__explicitlySet__.add("namePath");
            return this;
        }

        public Builder timeUpdatedInMillis(Long timeUpdatedInMillis) {
            this.timeUpdatedInMillis = timeUpdatedInMillis;
            this.__explicitlySet__.add("timeUpdatedInMillis");
            return this;
        }

        public ExportObjectMetadataSummary build() {
            ExportObjectMetadataSummary model = new ExportObjectMetadataSummary(this.key, this.name, this.identifier, this.objectType, this.objectVersion, this.aggregatorKey, this.namePath, this.timeUpdatedInMillis);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExportObjectMetadataSummary model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("objectType")) {
                this.objectType(model.getObjectType());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("aggregatorKey")) {
                this.aggregatorKey(model.getAggregatorKey());
            }
            if (model.wasPropertyExplicitlySet("namePath")) {
                this.namePath(model.getNamePath());
            }
            if (model.wasPropertyExplicitlySet("timeUpdatedInMillis")) {
                this.timeUpdatedInMillis(model.getTimeUpdatedInMillis());
            }
            return this;
        }
    }
}

